/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.msro.openaireplus.workflows.nodes.index.ContextLoader;
import eu.dnetlib.msro.openaireplus.workflows.nodes.index.EntityGrouperConfigurationLoader;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

public class PrepareIndexDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareIndexDataJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Autowired
    private ContextLoader contextLoader;
    @Autowired
    private EntityGrouperConfigurationLoader grouperConfLoader;
    private String layoutToRecordStylesheet;
    private String outputRecordsPathParam;
    private String rottenRecordsPathParam;
    private String hbaseTable;

    protected String execute(NodeToken token) throws Exception {
        log.info((Object)"start preparing job");
        String xslt = this.prepareXslt(this.env("format", token), this.env("layout", token));
        token.getEnv().setAttribute("contextmap", this.contextLoader.load());
        token.getEnv().setAttribute("index.entity.links", this.grouperConfLoader.load());
        token.getEnv().setAttribute("index.xslt", xslt);
        token.getEnv().setAttribute(this.getOutputRecordsPathParam(), "/tmp" + this.getFileName(token, "indexrecords"));
        token.getEnv().setAttribute(this.getRottenRecordsPathParam(), "/tmp" + this.getFileName(token, "rottenrecords"));
        token.getEnv().setAttribute("index.solr.url.zk", this.getIndexSolrUrlZk());
        token.getEnv().setAttribute("index.solr.url.local", this.getIndexSolrUrlLocal());
        token.getEnv().setAttribute("index.solr.url.list", this.getIndexSolrUrlList());
        token.getEnv().setAttribute("index.shutdown.wait.time", this.getIndexSolrShutdownWait());
        token.getEnv().setAttribute("index.buffer.flush.threshold", this.getIndexBufferFlushTreshold());
        token.getEnv().setAttribute("index.solr.local.feeding", this.isIndexLocalFeeding());
        token.getEnv().setAttribute("index.solr.sim.mode", this.isFeedingSimulationMode());
        token.getEnv().setAttribute("index.solr.collection", this.getCollectionName(token));
        token.getEnv().setAttribute("index.feed.timestamp", DateUtils.now_ISO8601());
        return Arc.DEFAULT_ARC;
    }

    public String getIndexSolrUrlZk() throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='SOLR']/@address/string()");
    }

    public String getIndexSolrUrlLocal() throws ISLookUpException {
        return this.queryForServiceProperty("hadoopLocalUrl");
    }

    public String getIndexSolrUrlList() throws ISLookUpException {
        return this.queryForServiceProperty("clientPoolUrls");
    }

    public String getIndexSolrShutdownWait() throws ISLookUpException {
        return this.queryForServiceProperty("feedingShutdownTolerance");
    }

    public String getIndexBufferFlushTreshold() throws ISLookUpException {
        return this.queryForServiceProperty("feedingBufferFlushThreshold");
    }

    public String isIndexLocalFeeding() throws ISLookUpException {
        return this.queryForServiceProperty("feedingOnLocalUrls");
    }

    public String isFeedingSimulationMode() throws ISLookUpException {
        return this.queryForServiceProperty("feedingSimulationMode");
    }

    private String queryForServiceProperty(String key) throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    private String getServiceConfigValue(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        List urls = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xquery);
        if (urls == null || urls.size() != 1) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return (String)Iterables.getOnlyElement((Iterable)urls);
    }

    private String getFileName(NodeToken token, String fileNamePrefix) {
        return "/" + fileNamePrefix + "_" + this.getHbaseTable() + "_" + token.getEnv().getAttribute("format") + ".seq";
    }

    private String getCollectionName(NodeToken token) {
        return this.env("format", token) + "-" + this.env("layout", token) + "-" + this.env("interpretation", token);
    }

    private String env(String s, NodeToken token) {
        return token.getEnv().getAttribute(s);
    }

    protected String prepareXslt(String format, String layout) throws ISLookUpException, IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer layoutTransformer = factory.newTransformer(new StreamSource(new StringReader(this.readXslt(this.getLayoutToRecordStylesheet()))));
        StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format, layout))), layoutToXsltXslt);
        return new String(Hashing.encodeBase64((String)layoutToXsltXslt.getWriter().toString()));
    }

    private String readXslt(String s) throws IOException {
        ClassPathResource resource = new ClassPathResource(s);
        InputStream inputStream = resource.getInputStream();
        return IOUtils.toString((InputStream)inputStream);
    }

    private String getLayoutSource(String format, String layout) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + format + "']//LAYOUT[@name='" + layout + "']");
    }

    public String getLayoutToRecordStylesheet() {
        return this.layoutToRecordStylesheet;
    }

    public void setLayoutToRecordStylesheet(String layoutToRecordStylesheet) {
        this.layoutToRecordStylesheet = layoutToRecordStylesheet;
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    @Required
    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }

    public String getOutputRecordsPathParam() {
        return this.outputRecordsPathParam;
    }

    public void setOutputRecordsPathParam(String outputRecordsPathParam) {
        this.outputRecordsPathParam = outputRecordsPathParam;
    }

    public String getRottenRecordsPathParam() {
        return this.rottenRecordsPathParam;
    }

    public void setRottenRecordsPathParam(String rottenRecordsPathParam) {
        this.rottenRecordsPathParam = rottenRecordsPathParam;
    }
}

