/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopJobType;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubmitHadoopJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(SubmitHadoopJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String hadoopJob;
    private String cluster;

    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        String type = this.getJobType(this.getHadoopJob());
        log.info((Object)("submitting job " + this.getHadoopJob() + " type: " + type));
        job.setAction(type);
        job.getParameters().put("job.name", this.getHadoopJob());
        job.getParameters().put("cluster", this.getCluster());
        job.getParameters().putAll(this.parseJsonParameters(token));
    }

    private String getJobType(String jobName) throws ISLookUpException {
        List res = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType']//HADOOP_JOB[./@name='" + jobName + "']/@type/string()");
        if (res.isEmpty()) {
            throw new IllegalStateException("unable to find job type for job: " + jobName);
        }
        HadoopJobType type = HadoopJobType.valueOf((String)((String)Iterables.getOnlyElement((Iterable)res)));
        switch (type) {
            case mapreduce: {
                return HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString();
            }
            case oozie: {
                return HadoopBlackboardActions.SUBMIT_OOZIE_JOB.toString();
            }
        }
        throw new IllegalStateException("undefined job type: " + type.toString());
    }

    public String getHadoopJob() {
        return this.hadoopJob;
    }

    public void setHadoopJob(String hadoopJob) {
        this.hadoopJob = hadoopJob;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }
}

