/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class StoreHdfsRecordsJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(StoreHdfsRecordsJobNode.class);
    private String inputEprParam;
    private String hdfsPathParam;
    private String cluster;
    private ProgressProvider progressProvider;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;

    protected String getXqueryForServiceId(NodeToken token) {
        return "collection('/db/DRIVER/ServiceResources/HadoopServiceResourceType')//RESOURCE_IDENTIFIER/@value/string()";
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        log.info((Object)"Invoking blackboard method");
        job.setAction(HadoopBlackboardActions.IMPORT_EPR_HDFS.toString());
        job.getParameters().put("input_epr", DnetXsltFunctions.encodeBase64((String)this.prepareEpr(token)));
        job.getParameters().put("path", token.getEnv().getAttribute(this.getHdfsPathParam()));
        job.getParameters().put("cluster", this.getCluster());
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:" + StoreHdfsRecordsJobNode.this.getName() + ":count", responseParams.get("count"));
            }
        };
    }

    private String prepareEpr(NodeToken token) throws ResultSetException {
        String epr = token.getEnv().getAttribute(this.inputEprParam);
        ResultsetProgressProvider resultsetProgressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        this.setProgressProvider((ProgressProvider)resultsetProgressProvider);
        return resultsetProgressProvider.getEpr().toString();
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHdfsPathParam() {
        return this.hdfsPathParam;
    }

    public void setHdfsPathParam(String hdfsPathParam) {
        this.hdfsPathParam = hdfsPathParam;
    }
}

