/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.openaireplus.workflows.hbase.HBaseTableUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class PrepareHBaseJobNode
extends SimpleJobNode {
    private String hbaseTableProperty;
    private String cluster;
    private ServiceLocator<HadoopService> hadoopServiceLocator;
    private static final Log log = LogFactory.getLog(PrepareHBaseJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        Set<String> columns = HBaseTableUtils.listColumns();
        String tableName = this.tableName();
        log.debug((Object)("Ensuring table " + tableName + " - columns: " + columns));
        ((HadoopService)this.hadoopServiceLocator.getService()).ensureHbaseTable(this.cluster, tableName, columns);
        return Arc.DEFAULT_ARC;
    }

    private String tableName() {
        return this.getPropertyFetcher().getProperty(this.getHbaseTableProperty());
    }

    public ServiceLocator<HadoopService> getHadoopServiceLocator() {
        return this.hadoopServiceLocator;
    }

    @Required
    public void setHadoopServiceLocator(ServiceLocator<HadoopService> hadoopServiceLocator) {
        this.hadoopServiceLocator = hadoopServiceLocator;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHbaseTableProperty() {
        return this.hbaseTableProperty;
    }

    public void setHbaseTableProperty(String hbaseTableProperty) {
        this.hbaseTableProperty = hbaseTableProperty;
    }
}

