/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreBatchExporterJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(MDStoreBatchExporterJobNode.class);
    private String format;
    private String layout;
    private String interpretation;
    private String outputEprParam;
    private ServiceLocator<MDStoreService> mdstoreLocator;

    public String execute(NodeToken token) throws Exception {
        log.info((Object)("bulk reading MDStores: " + this.getFormat() + "-" + this.getLayout() + "-" + this.getInterpretation()));
        W3CEndpointReference epr = ((MDStoreService)this.getMdstoreLocator().getService()).bulkDeliverMDRecords(this.getFormat(), this.getLayout(), this.getInterpretation());
        token.getEnv().setAttribute(this.getOutputEprParam(), epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public ServiceLocator<MDStoreService> getMdstoreLocator() {
        return this.mdstoreLocator;
    }

    @Required
    public void setMdstoreLocator(ServiceLocator<MDStoreService> mdstoreLocator) {
        this.mdstoreLocator = mdstoreLocator;
    }
}

