/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class UpdateSetsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(UpdateSetsJobNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;

    protected String execute(NodeToken token) throws Exception {
        List sets = (List)new Gson().fromJson(token.getEnv().getAttribute("sets"), List.class);
        String lastUpdate = DateUtils.now_ISO8601();
        for (Map set : sets) {
            log.info((Object)("updating set: " + set.toString()));
            this.addLatestRawSet(set, lastUpdate);
        }
        return Arc.DEFAULT_ARC;
    }

    public void addLatestRawSet(Map<String, String> set, String lastUpdate) throws MSROException {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + set.get("set") + "' return $x";
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(q);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            String profId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            Element latest = (Element)doc.selectSingleNode("//RAW_SETS/LATEST");
            Element expired = ((Element)doc.selectSingleNode("//RAW_SETS")).addElement("EXPIRED");
            for (Object o : latest.attributes()) {
                Attribute a = (Attribute)o;
                expired.addAttribute(a.getName(), a.getValue());
            }
            latest.addAttribute("id", set.get("rawset"));
            latest.addAttribute("creationDate", set.get("creationDate"));
            latest.addAttribute("lastUpdate", lastUpdate);
            ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, doc.asXML(), "ActionManagerSetDSResourceType");
        }
        catch (Exception e) {
            String msg = "Error updating profile of set: " + set;
            log.error((Object)msg);
            throw new MSROException(msg, (Throwable)e);
        }
    }
}

