/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.msro.openaireplus.workflows.nodes.FindExistingRepositoriesJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class UpdateRepositoryProfilesJobNode
extends SimpleJobNode
implements ProgressJobNode {
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;
    @Resource
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private String eprParam = "repoEpr";
    private String existingReposParam = "existingRepos";
    private ResultsetProgressProvider progressProvider;
    private static final Log log = LogFactory.getLog(UpdateRepositoryProfilesJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        Map existingRepos = (Map)token.getFullEnv().getTransientAttribute(this.getExistingReposParam());
        W3CEndpointReference epr = (W3CEndpointReference)token.getFullEnv().getTransientAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        SAXReader reader = new SAXReader();
        int countUpdated = 0;
        int countInserted = 0;
        int countProfileErrors = 0;
        int countErrorsWithActiveInterfaces = 0;
        log.info((Object)"Adding/updating repository profiles...");
        for (String profile : this.resultSetClientFactory.getClient(this.progressProvider.getEpr())) {
            try {
                String profId;
                Document doc = reader.read((Reader)new StringReader(profile));
                String dsId = doc.valueOf("//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value");
                int nActiveInterfaces = doc.selectNodes("//INTERFACE[@active='true']").size();
                log.debug((Object)("Registering/updating profile:\n " + profile + "\n"));
                if (existingRepos.containsKey(dsId)) {
                    FindExistingRepositoriesJobNode.RepositoryInfo info = (FindExistingRepositoriesJobNode.RepositoryInfo)existingRepos.get(dsId);
                    doc.selectSingleNode("//RESOURCE_IDENTIFIER/@value").setText(info.repoId);
                    doc.selectSingleNode("//RESOURCE_KIND/@value").setText(info.resourceKind);
                    ((ISRegistryService)this.registryLocator.getService()).updateProfile(info.repoId, doc.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
                    log.debug((Object)("Profile " + info.repoId + " UPDATED for ds " + dsId));
                    ++countUpdated;
                    if (DatasourceFunctions.verifyCompliance((Document)doc) && info.resourceKind.equals("PendingRepositoryResources")) {
                        ((ISRegistryService)this.registryLocator.getService()).validateProfile(info.repoId);
                    }
                    if (DatasourceFunctions.verifyCompliance((Document)doc) || !info.resourceKind.equals("RepositoryServiceResources")) continue;
                    if (nActiveInterfaces == 0) {
                        ((ISRegistryService)this.registryLocator.getService()).invalidateProfile(info.repoId);
                        continue;
                    }
                    ++countErrorsWithActiveInterfaces;
                    continue;
                }
                if (DatasourceFunctions.verifyCompliance((Document)doc) || nActiveInterfaces > 0) {
                    profId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(doc.asXML());
                    log.debug((Object)("Valid Profile " + profId + " REGISTERED for ds " + dsId));
                    if (!DatasourceFunctions.verifyCompliance((Document)doc)) {
                        ++countErrorsWithActiveInterfaces;
                    }
                } else {
                    profId = ((ISRegistryService)this.registryLocator.getService()).insertProfileForValidation(REPOSITORY_SERVICE_RESOURCE_TYPE, doc.asXML());
                    log.debug((Object)("Pending Profile " + profId + " REGISTERED for ds " + dsId));
                }
                ++countInserted;
            }
            catch (Exception e) {
                log.error((Object)("INVALID PROFILE: " + profile), (Throwable)e);
                ++countProfileErrors;
            }
        }
        log.info((Object)("   - updated_profiles: " + countUpdated));
        log.info((Object)("   - inserted_profiles: " + countInserted));
        log.info((Object)("   - profiles_with_errors: " + countProfileErrors));
        log.info((Object)("   - invalidCompatibilityLevelForDsWithActiveInterfaces: " + countErrorsWithActiveInterfaces));
        token.getEnv().setAttribute("mainlog:updated_profiles", (Object)countUpdated);
        token.getEnv().setAttribute("mainlog:inserted_profiles", (Object)countInserted);
        token.getEnv().setAttribute("mainlog:profiles_with_errors", (Object)countProfileErrors);
        token.getEnv().setAttribute("mainlog:invalidCompatibilityLevelForDsWithActiveInterfaces", (Object)countErrorsWithActiveInterfaces);
        return Arc.DEFAULT_ARC;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getExistingReposParam() {
        return this.existingReposParam;
    }

    public void setExistingReposParam(String existingReposParam) {
        this.existingReposParam = existingReposParam;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }
}

