var statsInspectorControllers = angular.module('statsInspectorControllers', ['LocalStorageModule']);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { $location.path(path); }
	$scope.encodeValue      = function(val)     { return val; }
}

statsInspectorControllers.directive('compileTemplate', function($compile, $parse){
    return {
            link: function(scope, element, attr){
                    var parsed = $parse(attr.ngBindHtml);
        
                    function getStringValue() { return (parsed(scope) || '').toString(); }

                    //Recompile if the template changes
                    scope.$watch(getStringValue, function() {
            $compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
                    });
            }         
    }
});

function hasOwnProperty(obj, prop) {
    var proto = obj.__proto__ || obj.constructor.prototype;
    return (prop in obj) &&
        (!(prop in proto) || proto[prop] !== obj[prop]);
}



statsInspectorControllers.controller('statsController', [
               	'$scope', '$http', '$sce', '$location', '$routeParams',
              	function ($scope, $http, $sce, $location, $routeParams) {
              		common_init($scope, $http, $sce, $location);           		
              		$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
              		$scope.loadInfo= function() {
              			$scope.showSpinner(); 
              			$http.get('stats/infostats.do').success(function(data) {
                   			$scope.hideSpinner();
                   			$scope.statsInfo = data;
                   			$scope.numberOfDatasets= []
                   			
                   			for  (item in data) {
                   				
                   				$scope.numberOfDatasets.push({label: data[item].datasource, value: data[item].numberOfDatasets})
                   				
                   			}
                   			console.log($scope.numberOfDatasets);
                   			
                   			
                   			
                   			if (hasOwnProperty($scope, 'searchResult') == false) {
                   				$scope.searchResult={}
                   			}
                   			
                   			$scope.searchResult.total =data.size;
                   		}).error(function() {
                   			$scope.showError('Error getting info from stats');
                   			$scope.hideSpinner();
                   	    });
              			$scope.hideSpinner();
					}
              		
              		$scope.refreshInfo= function() {
              			$scope.showSpinner(); 
              			$http.get('stats/refreshInfostats.do').success(function(data) {
                   			$scope.hideSpinner();
                   			$scope.statsInfo = data;
                   			if (hasOwnProperty($scope, 'searchResult') == false) {
                   				$scope.searchResult={}
                   				
                   			}
                   			
                   			$scope.searchResult.total =data.size;
                   		}).error(function() {
                   			$scope.showError('Error getting info from stats');
                   			$scope.hideSpinner();
                   	    });
              			$scope.hideSpinner();
					}
              		
              		$scope.numberOfDatasets = [
              		                {label: "Crossref", value: 237638},
              		                {label: "OpenAIRE", value: 7677},
              		                {label: "DataCite", value: 1}
              		              ];
              		
              		
              		console.log($scope.myModel)
              		$scope.loadInfo();              		
              		
              	}]); 

