var module = angular.module('statsInspector', [ 'ngRoute', 'statsInspectorControllers']);

module.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
			.when('/stats',		{ templateUrl: '../resources/html/stats/stats.html', controller: 'statsController' })			
			.otherwise({ redirectTo: '/stats' });
	}
]);


module.controller('moduleMenuCtrl', [ '$scope', '$location',  
	function ($scope, $location) {
		$scope.isActive = function(regex) {
			var re = new RegExp(regex);			
			return re.test($location.path());
		}
	}
]);

module.filter('encodeURIComponent', function() {
    return window.encodeURIComponent;
});


module.directive('donut', function() {

    return {

        // required to make it work as an element
        restrict: 'E',
        template: '<div></div>',
        replace: true,
        // observe and manipulate the DOM
        link: function($scope, element, attrs) {

            var data = $scope[attrs.data];

            Morris.Donut({
                    element: element,
                    data: data,                    
                });

        }

    };
});
/*
module.directive('donut', function ($window) {

    return {
        restrict: 'E',
        template: '<div></div>',
        replace: true,
        link: function ($scope, element, attrs) {
            var morris;
            angular.element($window).bind('resize', function () {
                if (morris) {
                    console.log('morris resized');
                    morris.redraw();
                }
            });

            attrs.$observe('value', function (val) {
                if (!morris) {
                    console.log('creating chart');
                    morris = Morris.Donut({
                        element: element,
                        data: angular.fromJson(val);
                        
                    });
                } else {
                    console.log('setting chart values');
                    morris.setData(angular.fromJson(val));
                }
            });
        }
    };
});
}).call(this);
*/


