DELETE FROM relation_provenance_tmp;
WITH updated_rows AS (
  UPDATE dli_relation
  SET (target_type, target_authors, target_title, relationship_completion_status) = (o.type, o.authors, COALESCE(
      o.title [1], ''), 'complete') FROM dli_object o
  WHERE target_pid = o.pid AND relationship_completion_status <> 'complete' AND o.completion_status = 'complete'
  RETURNING 'dli::system' AS ds_id, id_relation AS id_rels, 'system_deducted', 'complete'
) INSERT INTO relation_provenance_tmp SELECT *
                                      FROM updated_rows;
DELETE FROM relation_provenance
WHERE (ds_id, id_relation) IN (
  SELECT
    ds_id,
    id_relation
  FROM relation_provenance_tmp
);
INSERT INTO relation_provenance (SELECT *
                                 FROM relation_provenance_tmp);


