/**
 *
 */
package eu.dnetlib.msro.workflows.dli.resolver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.msro.workflows.dli.model.DLIObject;



/**
 * The Class RCBSResolver.
 *
 * @author sandro
 */
public class RCSBResolver implements DOIResolver {


	/** The Constant log. */
	private static final Log log = LogFactory.getLog(RCSBResolver.class); // NOPMD by marko on 11/24/08 5:02 PM


	/** The template url. */
	private static String TEMPLATE_URL = "http://www.rcsb.org/pdb/rest/customReport?pdbids=%s&customReportColumns=structureTitle,structureAuthor,releaseDate&service=wsfile";


	/** The rcbs parser. */
	@Autowired
	private  RCSBParser rcbsParser;



	/**
	 * Request doi.
	 *
	 * @param URL the url
	 * @return the string
	 */
	private String requestDOI(final String URL) {


		try {
			final URL myURl = new URL(URL);
			final String response = IOUtils.toString(myURl.openStream());
			return response;
		} catch (MalformedURLException e) {
			log.error("Error on request DOI, request :" + URL, e);
			return null;
		} catch (IOException e) {
			log.error("Error on request DOI, request :" + URL, e);
			return null;
		}

	}



	/**
	 * {@inheritDoc}
	 * @see eu.dnetlib.msro.workflows.dli.resolver.DOIResolver#retrieveDOI(java.lang.String, java.lang.String)
	 */
	@Override
	public DLIObject retrieveDOI(final String doi, final String doiType) {
		if(doiType== null) return null;
		if (doiType.toLowerCase().trim().equals("pdb")) {
			String URL = String.format(TEMPLATE_URL,doi);
			String response = requestDOI(URL);
			if(response== null) return null;
			return rcbsParser.parseRecord(response);
		}
		return null;
	}


}
