/**
 *
 */
package eu.dnetlib.msro.workflows.dli.resolver;

import java.io.ByteArrayInputStream;
import java.util.Stack;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;

import eu.dnetlib.msro.workflows.dli.model.DLICompletionStatus;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.model.DLIObjectType;
import eu.dnetlib.msro.workflows.dli.model.DLIProvenance;

/**
 * @author sandro
 *
 */
public class RCSBParser {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(RCSBParser.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The Constant CROSSREF_NS_PREFIX. */
	public static final String RCBS_NS_PREFIX = "dli::r3d100010327";

	/**
	 * Parses the record.
	 *
	 * @param record
	 *            the record
	 * @return the DLI object
	 */
	public DLIObject parseRecord(final String record) {
		try {
			XMLInputFactory factory = XMLInputFactory.newInstance();
			XMLStreamReader parser = factory.createXMLStreamReader(new ByteArrayInputStream(record.getBytes()));
			DLIObject object = new DLIObject();
			Stack<String> elementStack = new Stack<String>();
			elementStack.push("/");
			while (parser.hasNext()) {
				int event = parser.next();
				if (event == XMLStreamConstants.END_ELEMENT) {

					elementStack.pop();
				} else if (event == XMLStreamConstants.START_ELEMENT) {
					final String localName = parser.getLocalName();
					elementStack.push(localName);
					if ("dimStructure.structureId".equals(localName)) {
						log.debug("found open tag structureId");
						parser.next();
						if (parser.hasText()) {
							object.setPid(parser.getText().trim());
							object.setPidType("pdb");
						}
					} else if ("dimStructure.structureTitle".equals(localName)) {
						log.debug("found open tag structureTitle");
						parser.next();
						if (parser.hasText()) {
							String title = parser.getText().trim();
							object.setTitles(new String[] { title });
						}
					} else if ("dimStructure.structureAuthor".equals(localName)) {
						log.debug("found open tag structureAuthor");
						parser.next();
						if (parser.hasText()) {
							String author = parser.getText().trim();
							String[] splittedAuthrs = author.split("#");
							if (splittedAuthrs != null) {
								object.setAuthors(splittedAuthrs);
							}
						}
					} else if ("dimStructure.releaseDate".equals(localName)) {
						log.debug("found open tag releaseDate");
						parser.next();
						if (parser.hasText()) {
							String date = parser.getText().trim();
							object.setDate(date);
						}
					}

				}
			}
			if (object.getPid() != null && object.getPidType() != null) {
				DLIProvenance provenance = new DLIProvenance(RCBS_NS_PREFIX, "resolved", "complete", null, null, true, "RCSB", "",RCBS_NS_PREFIX);
				object.setDatasourceProvenance(Lists.newArrayList(provenance));
				object.fixContribution(provenance);
				object.setType(DLIObjectType.dataset);
				object.setCompletionStatus(DLICompletionStatus.complete.toString());
				return object;
			}
			return null;

		} catch (XMLStreamException e) {
			log.error("error during parsing record " + record, e);
			return null;
		}

	}

}
