package eu.dnetlib.msro.workflows.dli.resolver;

import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.io.IOException;
import java.net.URLEncoder;

// TODO: Auto-generated Javadoc

/**
 * The Class CrossrefDOIResolver.
 */
public class CrossrefDOIResolver implements DOIResolver {

    /**
     * The Constant log.
     */
    private static final Log log = LogFactory.getLog(CrossrefDOIResolver.class); // NOPMD by marko on 11/24/08 5:02 PM

    //	/** The Constant baseUrlCrossref. */
    //	private final static String baseUrlCrossref = "http://www.crossref.org/openurl?noredirect=true&pid=antleb%40di.uoa.gr&format=unixref&id=";

    /**
     * The Constant baseUrlCrossref.
     */
    private final static String baseUrlCrossref = "http://api.crossref.org/works/";

    /**
     * The cache.
     */
    @Resource(name = "crossrefDOICache")
    private Cache cache;

    /**
     * The parser.
     */
    @Autowired
    private CrossRefParserJSON parser;

    /**
     * The Constant NOT_FOUND_ELEMENT.
     *
     * @param doi the doi
     * @return the DLI object
     */

    @Override
    public DLIObject retrieveDOI(final String doi, final String doiType) {
        final Element elem = cache.get(doi);
        if ((doiType == null) || !"doi".equals(doiType.toLowerCase().trim())) return null;
        if (elem != null) return (DLIObject) elem.getObjectValue();
        else {
            log.debug("Refreshing " + doi + " cache...");
            DLIObject obj = requestDOI(doi);
            if (obj != null) {
                cache.put(new Element(doi, obj));
            }
            return obj;
        }

    }

    /**
     * Request doi.
     *
     * @param doi the doi
     * @return the DLI object
     */
    private DLIObject requestDOI(final String doi) {

        CloseableHttpResponse response1 = null;

        try {

            RequestConfig defaultRequestConfig = RequestConfig.custom()
                    .build();
            CloseableHttpClient httpclient = HttpClients.custom()
                    .setDefaultRequestConfig(defaultRequestConfig)
                    .setUserAgent("Mozilla/4.0")
                    .build();
            HttpGet httpGet = new HttpGet(baseUrlCrossref + URLEncoder.encode(doi, "UTF-8"));

            response1 = httpclient.execute(httpGet);
            HttpEntity entity1 = response1.getEntity();
            String response = IOUtils.toString(entity1.getContent());
            log.debug("Obtainded " + response);
            if (response == null) return null;
            if (response.contains("Resource not found")) return null;
            DLIObject record = parser.parseRecord(response);
            if (record.getPid() == null) return null;
            return record;

        } catch (Exception e) {
            log.error("Error on gettig Item: " + doi, e);
            return null;
        } finally {
            if (response1 != null) {
                try {
                    response1.close();
                } catch (IOException e) {
                    log.error("Error on closing response");
                }
            }
        }
    }
}
