/**
 *
 */
package eu.dnetlib.msro.workflows.dli.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.msro.workflows.dli.model.DLICompletionStatus;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.model.DLIObjectType;
import eu.dnetlib.msro.workflows.dli.model.DLIProvenance;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

/**
 * @author sandro
 */
public class CrossRefParserJSON {

    /**
     * The Constant CROSSREF_NS_PREFIX.
     */
    public static final String CROSSREF_NS_PREFIX = "dli::crossref";
    private static final Log log = LogFactory.getLog(CrossRefParserJSON.class); // NOPMD by marko on 11/24/08 5:02 PM

    public DLIObject parseRecord(final String record) {

        if (record == null) return null;
        JsonElement jElement = new JsonParser().parse(record);
        JsonObject mainObj = jElement.getAsJsonObject();
        if (mainObj.get("message").isJsonNull()) {
            return null;
        }
        JsonObject message = mainObj.getAsJsonObject("message");
        DLIObject currentObject = new DLIObject();

        if (message.get("DOI") != null) {
            currentObject.setPid(message.get("DOI").getAsString());
            currentObject.setPidType("doi");
        }

        if ((!message.get("created").isJsonNull()) && (message.getAsJsonObject("created").get("date-time") != null)) {
            currentObject.setDate(message.getAsJsonObject("created").get("date-time").getAsString());
        }

        if (!message.get("title").isJsonNull()) {
            currentObject.setTitles(new String[]{message.get("title").toString()});
        }

        if (message.get("author") != null && !message.get("author").isJsonNull()) {
            JsonArray author = message.getAsJsonArray("author");
            List<String> authorList = Lists.newArrayList();
            for (JsonElement anAuthor : author) {
                JsonObject currentAuth = anAuthor.getAsJsonObject();

                String family = "";
                String given = "";
                if (currentAuth != null && currentAuth.get("family") != null && !currentAuth.get("family").isJsonNull()) {
                    family = currentAuth.get("family").getAsString();
                }
                if (currentAuth != null && currentAuth.get("given") != null && !currentAuth.get("given").isJsonNull()) {
                    given = currentAuth.get("given").getAsString();
                }
                authorList.add(String.format("%s %s", family, given));
            }
            currentObject.setAuthors(authorList.toArray(new String[]{}));
        }
        DLIProvenance provenance = new DLIProvenance(CROSSREF_NS_PREFIX, "resolved", "complete", null, null, true);
        if(message.get("publisher") != null && !message.get("publisher").isJsonNull()) {
            provenance.setPublisher(message.get("publisher").getAsString());
        }
        currentObject.fixContribution(provenance);
        currentObject.setDatasourceProvenance(Lists.newArrayList(provenance));
        currentObject.setCompletionStatus(DLICompletionStatus.complete.toString());

        if (!message.get("type").isJsonNull()) {
            final String type = message.get("type").getAsString();
            if ("component".equals(type) || "dataset".equals(type)) {
                currentObject.setType(DLIObjectType.dataset);
            } else
                currentObject.setType(DLIObjectType.publication);

        }


        return currentObject;

    }

    /**
     * @param fullCitations
     * @param result
     */
    private void parseFullCitation(final String fullCitations, final DLIObject result) {
        if (StringUtils.isEmpty(fullCitations))
            return;

        String beforeTitles[] = fullCitations.split("'");

        if (ArrayUtils.isEmpty(beforeTitles))
            return;

        String[] data = beforeTitles[0].split(",");
        if (ArrayUtils.isEmpty(data)) return;
        if (data.length > 1) {
            String date = data[data.length - 2];
            result.setDate(date.trim());
            List<String> authors = Lists.newArrayList();
            for (int i = 0; i < data.length - 2; i++) {
                authors.add(data[i]);
            }
            result.setAuthors(authors.toArray(new String[]{}));
        }
    }
}
