/**
 *
 */
package eu.dnetlib.msro.workflows.dli.resolver;

import java.net.URL;
import java.util.List;
import java.util.Scanner;

import org.apache.commons.io.IOUtils;

import com.google.common.collect.Lists;

import eu.dnetlib.msro.workflows.dli.model.DLICompletionStatus;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.model.DLIObjectType;
import eu.dnetlib.msro.workflows.dli.model.DLIProvenance;

/**
 * @author sandro
 *
 */
public class ANDSDataciteResolver implements DOIResolver {

	final static String url = "http://researchdata.ands.org.au/registry/registry_object/exportToEndnote/%s.ris";
	private static final String ANDS_NS_PREFIX = "ANDS";
	private static final String ANDS_EXPECTED_TYPE = "url";

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.msro.workflows.dli.resolver.DOIResolver#retrieveDOI(java.lang.String, java.lang.String)
	 */
	@Override
	public DLIObject retrieveDOI(final String doi, final String doiType) {

		if (doiType == null || !doiType.trim().toLowerCase().equals(ANDS_EXPECTED_TYPE)) return null;

		if (!doi.contains("https://researchdata.ands.org.au/registry/registry_object/view/"))
			return null;

		String[] splitted = doi.split("/");

		if (splitted == null || splitted.length == 0) return null;

		final String identifier = splitted[splitted.length - 1];

		URL myURl;
		try {
			myURl = new URL(String.format(url, identifier));
			final String myString = IOUtils.toString(myURl.openStream());
			Scanner scanner = new Scanner(myString);
			DLIObject object = new DLIObject();
			object.setCompletionStatus(DLICompletionStatus.complete.toString());
			object.setPid(doi);
			object.setPidType(doiType);
			DLIProvenance provenance = new DLIProvenance(ANDS_NS_PREFIX, "resolved", "complete", null, null, true);
			object.setDatasourceProvenance(Lists.newArrayList(provenance));
			object.fixContribution(provenance);
			object.setType(DLIObjectType.dataset);
			object.setCompletionStatus(DLICompletionStatus.complete.toString());
			object.setDatasourceProvenance(Lists.newArrayList(provenance));

			final List<String> authors = Lists.newArrayList();
			final List<String> titles = Lists.newArrayList();
			String date = null;
			while (scanner.hasNextLine()) {
				String line = scanner.nextLine();

				if (line.contains("AU  -")) {
					authors.add(line.replace("AU  -", ""));
				}

				if (line.contains("TI  -")) {
					titles.add(line.replace("TI  -", ""));
				}

				if (line.contains("Y2  -")) {
					date = line.replace("Y2  -", "");
				}

			}
			object.setAuthors(authors.toArray(new String[] {}));
			object.setTitles(titles.toArray(new String[] {}));
			object.setCompletionStatus(DLICompletionStatus.complete.toString());
			object.setDate(date);
			scanner.close();
			return object;
		} catch (Exception e) {
			return null;
		}

	}

}
