package eu.dnetlib.msro.workflows.dli.publisher;

import com.google.gson.*;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Sandro La Bruzzo on 1/13/16.
 */
public class PublisherResolverRuleDeserializer implements JsonDeserializer<PublisherConfigurationParameters> {

    private final static String PRIORITY_KEY = "priority";
    private final static String FIELD_KEY = "field";
    private final static String REGEXP_KEY = "regExp";
    private final static String RESULT_KEY = "key";


    @Override
    public PublisherConfigurationParameters deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            final JsonObject root = json.getAsJsonObject();
            final JsonArray source = root.get("source").getAsJsonArray();
            final JsonArray target = root.get("target").getAsJsonArray();
            final List<PublisherResolverRule> sourceResolver = new ArrayList<PublisherResolverRule>();
            final List<PublisherResolverRule> targetResolver = new ArrayList<PublisherResolverRule>();
            populateResolver(source, sourceResolver);
            populateResolver(target, targetResolver);
            PublisherConfigurationParameters parameters = new PublisherConfigurationParameters();
            parameters.setSource(sourceResolver);
            parameters.setTarget(targetResolver);
            return parameters;


        } catch (Throwable e) {
            throw new JsonParseException("Error on parsing json", e);
        }

    }

    protected void populateResolver(JsonArray source, List<PublisherResolverRule> sourceResolver) {
        for (JsonElement item : source) {
            PublisherResolverRule currentResolver = new PublisherResolverRule();

            final JsonObject currentObject = item.getAsJsonObject();
            if (currentObject.get(PRIORITY_KEY) != null && !currentObject.get(PRIORITY_KEY).isJsonNull())
                currentResolver.setPriority(currentObject.get(PRIORITY_KEY).getAsInt());
            if (currentObject.get(FIELD_KEY) != null && !currentObject.get(FIELD_KEY).isJsonNull())
                currentResolver.setField(currentObject.get(FIELD_KEY).getAsString());
            if (currentObject.get(REGEXP_KEY) != null && !currentObject.get(REGEXP_KEY).isJsonNull())
                currentResolver.setRegExp(currentObject.get(REGEXP_KEY).getAsString());
            if (currentObject.get(RESULT_KEY) != null && !currentObject.get(RESULT_KEY).isJsonNull())
                currentResolver.setKey(currentObject.get(RESULT_KEY).getAsString());
            sourceResolver.add(currentResolver);
        }
    }
}
