package eu.dnetlib.msro.workflows.dli.publisher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by sandro on 15/01/16.
 */
public class PublisherResolverFactory {

    private static final String queryTemplate = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value/string()='%s']//FIELD[key = 'provConfigParameters']/value/text()";


    @Autowired
    private UniqueServiceLocator locator;


    public PublisherResolver getInstance(final String datasourceId) throws ISLookUpException {
        ISLookUpService lookupService = locator.getService(ISLookUpService.class);
        List<String> results =lookupService.quickSearchProfile(String.format(queryTemplate, datasourceId));

        if (results.size()==0) {
            return null;
        }
        final String json = results.get(0);


        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(PublisherConfigurationParameters.class, new PublisherResolverRuleDeserializer());
        Gson gson = gsonBuilder.create();
        PublisherConfigurationParameters parameters = gson.fromJson(json, PublisherConfigurationParameters.class);

        PublisherResolver resolver= new PublisherResolver();
        resolver.setParameters(parameters);
        return resolver;
    }

}
