/*
 *
 */
package eu.dnetlib.msro.workflows.dli.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.dli.workflows.nodes.transform.DLIUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;

import java.util.Arrays;
import java.util.List;


// TODO: Auto-generated Javadoc

/**
 * The Class DLIRelation.
 */
public class DLIRelation {


    /**
     * The source doi.
     */
    private String sourceRecordId;

    /**
     * The source doi.
     */
    private String sourcePid;

    /**
     * The target type.
     */
    private DLIObjectType targetType;

    /**
     * The target pid.
     */
    private DLIPID targetPID;

    /**
     * The target title.
     */
    private String targetTitle;

    /**
     * The authors.
     */
    private List<String> authors;

    /**
     * The relation semantics.
     */
    private String relationSemantics;

    /**
     * The relation provenance.
     */
    private List<DLIProvenance> relationProvenance;

    /**
     * The status.
     */
    private String completionStatus = "incomplete";

    /**
     * Gets the source doi.
     *
     * @return the source doi
     */
    public String getSourceRecordId() {
        return sourceRecordId;
    }

    /**
     * Sets the source doi.
     *
     * @param sourceRecordId the new source record id
     */
    public void setSourceRecordId(final String sourceRecordId) {
        if (sourceRecordId != null) {
            this.sourceRecordId = sourceRecordId;
        }
    }

    /**
     * Gets the escaped xmldoi.
     *
     * @return the escaped xmldoi
     */
    public String getEscapedXMLDOI() {
        return StringEscapeUtils.escapeXml(sourceRecordId);
    }

    /**
     * Gets the target type.
     *
     * @return the target type
     */
    public DLIObjectType getTargetType() {
        return targetType;
    }

    /**
     * Sets the target type.
     *
     * @param targetType the new target type
     */
    public void setTargetType(final DLIObjectType targetType) {
        this.targetType = targetType;
    }

    /**
     * Gets the ID relation.
     *
     * @return the ID relation
     */
    public String getIDRelation() {

        if ((this.getSourceRecordId() == null) || (this.getTargetPID() == null) || (this.getTargetPID().getId() == null))
            return null;
        return String.format("%s::%s", this.getSourceRecordId(), DnetXsltFunctions.md5(getTargetPID().getId().toLowerCase().trim()));
    }


    public String getIDRecord() {
        return (DnetXsltFunctions.md5(String.format("%s::%s", this.getTargetPID().getId(), this.getTargetPID().getType())));
    }

    /**
     * Gets the target pid.
     *
     * @return the target pid
     */
    public DLIPID getTargetPID() {
        return targetPID;
    }

    /**
     * Sets the target pid.
     *
     * @param targetPID the new target pid
     */
    public void setTargetPID(final DLIPID targetPID) {

        if (targetPID.getType() != null && "doi".equals(targetPID.getType().trim().toLowerCase()))
            targetPID.setId(DLIUtils.fixPID(targetPID.getId()));
        this.targetPID = targetPID;
    }

    /**
     * Gets the target title.
     *
     * @return the target title
     */
    public String getTargetTitle() {
        if (targetTitle == null) return null;
        String bf = targetTitle;
        bf = bf.replaceAll("&", "&amp;");
        bf = bf.replaceAll("\"", "&quot;");
        bf = bf.replaceAll("'", "&apos;");
        bf = bf.replaceAll("<", "&lt;");
        bf = bf.replaceAll(">", "&gt;");
        return bf;
    }

    /**
     * Sets the target title.
     *
     * @param targetTitle the new target title
     */
    public void setTargetTitle(final String targetTitle) {
        this.targetTitle = targetTitle;
    }

    /**
     * Gets the relation semantics.
     *
     * @return the relation semantics
     */
    public String getRelationSemantics() {
        return relationSemantics;
    }

    /**
     * Sets the relation semantics.
     *
     * @param relationSemantics the new relation semantics
     */
    public void setRelationSemantics(final String relationSemantics) {
        this.relationSemantics = relationSemantics;
    }

    /**
     * Gets the relation provenance.
     *
     * @return the relationProvenance
     */
    public List<DLIProvenance> getRelationProvenance() {
        return relationProvenance;
    }

    /**
     * Sets the relation provenance.
     *
     * @param relationProvenance the relationProvenance to set
     */
    public void setRelationProvenance(final List<DLIProvenance> relationProvenance) {
        this.relationProvenance = relationProvenance;
    }

    /**
     * Gets the completion status.
     *
     * @return the completion status
     */
    public String getCompletionStatus() {
        return this.completionStatus;
    }

    /**
     * Sets the completion status.
     *
     * @param completionStatus the new completion status
     */
    public void setCompletionStatus(final String completionStatus) {
        this.completionStatus = completionStatus;
    }

    /**
     * Gets the source pid.
     *
     * @return the source pid
     */
    public String getSourcePid() {
        return sourcePid;
    }

    /**
     * Sets the source pid.
     *
     * @param sourcePid the new source pid
     */
    public void setSourcePid(final String sourcePid) {
        this.sourcePid = sourcePid;
    }

    /**
     * {@inheritDoc}
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String format = "Relation: \n\tId:%s \n\tSourcePid%s \n\tTargetPid:%s \n\tTargetPidType:%s \n\ttitle:%s \n\tCompletionStatus:%s \n\t Relation Semantic:%s \n\tProvenances:%s";
        return String.format(format, this.getIDRelation(), this.getSourcePid(), this.getTargetPID(),
                this.getTargetType(), this.getTargetTitle(), this.getCompletionStatus(), this.getRelationSemantics(), Arrays.toString(relationProvenance.toArray()));
    }


    /**
     * Gets the authors.
     *
     * @return the authors
     */
    public List<String> getAuthors() {
        return authors;
    }

    /**
     * Sets the authors.
     *
     * @param authors the new authors
     */
    public void setAuthors(final List<String> authors) {
        this.authors = authors;
    }

    /**
     * Gets the escaped xml authors.
     *
     * @return the escaped xml authors
     */
    public String[] getEscapedXMLAuthors() {
        return escapedArray(authors);
    }

    /**
     * Escaped array.
     *
     * @param inputArray the input array
     * @return the string[]
     */
    private String[] escapedArray(final List<String> inputArray) {
        if ((inputArray == null) || (inputArray.size() == 0)) return null;
        Function<String, String> function = new Function<String, String>() {

            @Override
            public String apply(final String input) {

                String bf = input;
                bf = bf.replaceAll("&", "&amp;");
                bf = bf.replaceAll("\"", "&quot;");
                bf = bf.replaceAll("'", "&apos;");
                bf = bf.replaceAll("<", "&lt;");
                bf = bf.replaceAll(">", "&gt;");

                return bf;
            }
        };

        return Lists.transform(inputArray, function).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

}
