package eu.dnetlib.msro.workflows.dli.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// TODO: Auto-generated Javadoc
/**
 * The Enum DLIProvisionMode.
 *
 * @author sandro
 */
public enum DLIProvisionMode {

	/**  The resolved provision mode in case the relation of record was resolved. */
	resolved ,

	/**  The collected provision mode in case the relation of record was ingested during the collection. */
	collected ,

	/**  The pushed provision mode in case the relation of record was pushed by an external tool. */
	pushed,
	/** The system_deducted mode in case the relation has been deducted from the system, because it points to a PID into the IS */
	system_deducted,

	/**  The unknown provision mode in case of error during the parse of value. */
	unknown;

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(DLIProvisionMode.class); // NOPMD by marko on 11/24/08 5:02 PM


	/**
	 * From string.
	 *
	 * @param value the value
	 * @return the DLI provision mode
	 */
	public static DLIProvisionMode fromString(final String value) {
		try {
			DLIProvisionMode mode = DLIProvisionMode.valueOf(value);
			return mode;
		} catch (Throwable e) {
			log.debug("Error on parse the value of provision mode , value:"+value, e);
			return unknown;
		}
	}
}
