/**
 *
 */
package eu.dnetlib.msro.workflows.dli.model;

import org.apache.commons.lang.StringEscapeUtils;

// TODO: Auto-generated Javadoc

/**
 * The Class DLIProvenance.
 *
 * @author sandro
 */
public class DLIProvenance {

    /**
     * The datasource.
     */
    private String datasource;


    private String datasourceId;

    /**
     * The publisher.
     */
    private String publisher;


    /**
     * The publisher identifier can be null
     */
    private String publisherId;

    /**
     * The provision mode.
     */
    private String provisionMode;

    /**
     * The completion status.
     */
    private String completionStatus;

    /**
     * The visible.
     */
    private boolean visible;

    /**
     * The datasource contribution.
     */
    private String datasourceContribution;

    /**
     * The collection date.
     */
    private String collectionDate;

    /**
     * Instantiates a new DLI provenance.
     *
     * @param datasource       the datasource
     * @param provisionMode    the provision mode
     * @param completionStatus the completion status
     * @param contribution     the contribution
     */
    public DLIProvenance(final String datasource, final String provisionMode, final String completionStatus, final String contribution,
                         final String collectionDate, final boolean visible) {
        super();
        this.datasource = datasource;
        this.provisionMode = provisionMode;
        this.completionStatus = completionStatus;
        this.datasourceContribution = contribution;
        this.collectionDate = collectionDate;
        this.visible = visible;
    }


    public DLIProvenance(final String datasource, final String provisionMode, final String completionStatus, final String contribution,
                         final String collectionDate, final boolean visible, final String datasourceId, final String publisher, final String publisherId) {
        this(datasource, provisionMode, completionStatus, contribution, collectionDate, visible);
        this.publisher = publisher;
        this.publisherId = publisherId;
        this.datasourceId = datasourceId;
    }


    /**
     * Instantiates a new DLI provenance.
     */
    public DLIProvenance() {

    }

    /**
     * Get the Publisher identifier
     *
     * @return the publisher
     */
    public String getPublisherId() {
        return publisherId;
    }


    /**
     * Set the Publisher identifier
     *
     * @param publisher
     */
    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }


    /**
     * Get the Publisher
     *
     * @return the publisher
     */
    public String getPublisher() {
        return publisher;
    }


    public String getEscapedPublisher() {
        return  StringEscapeUtils.escapeXml(this.publisher);
    }


    /**
     * Set the Publisher
     *
     * @param publisher
     */
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    /**
     * Gets the datasource.
     *
     * @return the datasource
     */
    public String getDatasource() {
        return datasource;
    }

    /**
     * Sets the datasource.
     *
     * @param datasource the new datasource
     */
    public void setDatasource(final String datasource) {
        this.datasource = datasource;
    }

    /**
     * Gets the escaped datasource.
     *
     * @return the escaped datasource
     */
    public String getEscapedDatasource() {
        return StringEscapeUtils.escapeXml(this.datasource);
    }


    public String getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getEscapedDatasourceId() {
        return StringEscapeUtils.escapeXml(this.datasourceId);
    }

    /**
     * Gets the provision mode.
     *
     * @return the provision mode
     */
    public String getProvisionMode() {
        return provisionMode;
    }

    /**
     * Sets the provision mode.
     *
     * @param provisionMode the new provision mode
     */
    public void setProvisionMode(final String provisionMode) {
        this.provisionMode = provisionMode;
    }

    /**
     * Gets the completion status.
     *
     * @return the completion status
     */
    public String getCompletionStatus() {
        return completionStatus;
    }

    /**
     * Sets the completion status.
     *
     * @param completionStatus the new completion status
     */
    public void setCompletionStatus(final String completionStatus) {
        this.completionStatus = completionStatus;
    }

    /**
     * {@inheritDoc}
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String s = "\n\t\t%s \t Completion Status:%s \t Provision Mode:%s";
        return String.format(s, this.getDatasource(), this.getCompletionStatus(), this.getProvisionMode());
    }

    /**
     * Gets the datasource contribution.
     *
     * @return the datasource contribution
     */
    public String getDatasourceContribution() {
        return datasourceContribution;
    }

    /**
     * Sets the datasource contribution.
     *
     * @param datasourceContribution the new datasource contribution
     */
    public void setDatasourceContribution(final String datasourceContribution) {
        this.datasourceContribution = datasourceContribution;
    }

    /**
     * Gets the escaped xml datasource contribution.
     *
     * @return the escaped xml datasource contribution
     */
    public String getEscapedXMLDatasourceContribution() {
        return datasourceContribution.replaceAll("\"", "");
    }

    /**
     * Gets the collection date.
     *
     * @return the collection date
     */
    public String getCollectionDate() {
        return collectionDate;
    }

    /**
     * Sets the collection date.
     *
     * @param collectionDate the new collection date
     */
    public void setCollectionDate(final String collectionDate) {
        this.collectionDate = collectionDate;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(final boolean visible) {
        this.visible = visible;
    }

}
