package eu.dnetlib.msro.workflows.dli.model;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * The Class PID.
 */
public class DLIPID {

	/** The id. */
	private String id;

	/** The type. */
	private String type;

	/**
	 * Instantiates a new pid.
	 */
	public DLIPID() {

	}

	/**
	 * Instantiates a new pid.
	 *
	 * @param id
	 *            the id
	 * @param type
	 *            the type
	 */
	public DLIPID(final String id, final String type) {
		if (id != null) {
			this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
		}
		this.type = type;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	public String getEscapeXMLId() {
		return StringEscapeUtils.escapeXml(id);
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the id to set
	 */
	public void setId(final String id) {
		if (id != null) {
			this.id = id.replace("http://dx.doi.org/", "").toLowerCase();
		};
	}

	/**
	 * Gets the type.
	 *
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * Sets the type.
	 *
	 * @param type
	 *            the type to set
	 */
	public void setType(final String type) {
		if (type != null) {
			this.type = type.toUpperCase();
		} else {
			this.type = type;
		}
	}

	@Override
	public String toString() {
		return String.format("\n\t\tPid:%s \n\t\tPidType:%s ",this.id, this.type );
	}
}
