/**
 *
 */
package eu.dnetlib.msro.workflows.dli.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * The Enum DLICompletionStatus, enum the possible status of
 * DLIObject and DLIRelation
 *
 * @author sandro
 */
public enum DLICompletionStatus {



	/** The complete status. */
	complete,
	/** The incomplete status */
	incomplete,
	/** The failed_to_resolve status */
	failed_to_resolve;

	private static final Log log = LogFactory.getLog(DLICompletionStatus.class); // NOPMD by marko on 11/24/08 5:02 PM
	/**
	 * From string.
	 *
	 * @param value the value
	 * @return the DLI completion status
	 */
	public static DLICompletionStatus fromString(final String value) {
		try{
			DLICompletionStatus status = DLICompletionStatus.valueOf(value.toLowerCase().trim());
			return status;
		} catch (Throwable e) {
			log.debug("Failed to parse value: "+value +" completion status setted to incomplete",e);
			return incomplete;
		}
	}
}
