package eu.dnetlib.msro.workflows.dli.manager;

import com.mongodb.DBObject;

// TODO: Auto-generated Javadoc

/**
 * The Class StatsInfo.
 */
public class StatsInfo {

    /**
     *
     */
    private static final long serialVersionUID = -7548572789794311921L;

    private static String DATASET_KEY = "Datasets";
    private static String PUBLICATION_KEY = "Publications";
    private static String OBJECTS_KEY = "total";
    private static String LINKS_KEY = "links";
    private static String ACRONYM_KEY = "acronym";

    /**
     * The datasource.
     */
    private String datasource;


    private String acronym;

    /**
     * The number of datasets.
     */
    private int numberOfDatasets;

    /**
     * The numbero of publication.
     */
    private int numberOfPublication;

    /**
     * The number of relations.
     */
    private int numberOfRelations;

    /**
     * The number of objects.
     */
    private int numberOfObjects;

    /**
     * The dataset to dataset.
     */
    private int datasetToDataset;

    /**
     * The dataset to publication.
     */
    private int datasetToPublication;

    /**
     * Instantiates a new stats info.
     */
    public StatsInfo() {

    }

    public StatsInfo(final String datasource) {
        this.datasource = datasource;
    }

    /**
     * Instantiates a new stats info.
     *
     * @param datasource          the datasource
     * @param numberOfDatasets    the number of datasets
     * @param numberOfPublication the number of publication
     * @param numberOfRelations   the number of relations
     */
    public StatsInfo(final String datasource, final int numberOfDatasets, final int numberOfPublication, final int numberOfRelations,
                     final int numberOfObject) {
        super();
        this.datasource = datasource;
        this.numberOfDatasets = numberOfDatasets;
        this.numberOfPublication = numberOfPublication;
        this.numberOfRelations = numberOfRelations;
        this.numberOfObjects = numberOfObject;
    }

    public static StatsInfo fromMongoObject(final String datasource, final DBObject object) {

        StatsInfo info = new StatsInfo();
        info.setDatasource(datasource);

        for (String key : object.keySet()) {

            if (key.equals(DATASET_KEY)) {
                int datasets = Integer.parseInt("" + object.get(key));
                info.setNumberOfDatasets(datasets);
            } else if (key.equals(PUBLICATION_KEY)) {
                int publications = Integer.parseInt("" + object.get(key));
                info.setNumberOfPublication(publications);
            } else if (key.equals(LINKS_KEY)) {
                int links = Integer.parseInt("" + object.get(key));
                info.setNumberOfRelations(links);
            } else if (key.equals(OBJECTS_KEY)) {
                int objects = Integer.parseInt("" + object.get(key));
                info.setNumberOfObjects(objects);
            } else if (key.equals(ACRONYM_KEY) && object.get(key) != null) {
                final String acronym = object.get(key).toString();
                info.setAcronym(acronym);
            }
        }
        return info;
    }

    /**
     * Gets the datasource.
     *
     * @return the datasource
     */
    public String getDatasource() {
        return datasource;
    }

    /**
     * Sets the datasource.
     *
     * @param datasource the new datasource
     */
    public void setDatasource(final String datasource) {
        this.datasource = datasource;
    }

    /**
     * Gets the number of datasets.
     *
     * @return the number of datasets
     */
    public int getNumberOfDatasets() {
        return numberOfDatasets;
    }

    /**
     * Sets the number of datasets.
     *
     * @param numberOfDatasets the new number of datasets
     */
    public void setNumberOfDatasets(final int numberOfDatasets) {
        this.numberOfDatasets = numberOfDatasets;
    }

    /**
     * Gets the numbero of publication.
     *
     * @return the numbero of publication
     */
    public int getNumberOfPublication() {
        return numberOfPublication;
    }

    /**
     * Sets the numbero of publication.
     *
     * @param numberOfPublication the new number of publication
     */
    public void setNumberOfPublication(final int numberOfPublication) {
        this.numberOfPublication = numberOfPublication;
    }

    /**
     * Gets the number of relations.
     *
     * @return the number of relations
     */
    public int getNumberOfRelations() {
        return numberOfRelations;
    }

    /**
     * Sets the number of relations.
     *
     * @param numberOfRelations the new number of relations
     */
    public void setNumberOfRelations(final int numberOfRelations) {
        this.numberOfRelations = numberOfRelations;
    }


    public int getDatasetToDataset() {
        return datasetToDataset;
    }

    public void setDatasetToDataset(final int datasetToDataset) {
        this.datasetToDataset = datasetToDataset;
    }

    public int getDatasetToPublication() {
        return datasetToPublication;
    }

    public void setDatasetToPublication(final int datasetToPublication) {
        this.datasetToPublication = datasetToPublication;
    }

    public int getNumberOfObjects() {
        return numberOfObjects;
    }

    public void setNumberOfObjects(final int numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    public String getAcronym() {
        return acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }
}
