<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dli="http://www.dli.eu"
    exclude-result-prefixes="xsl datetime exslt ">

    <xsl:template match="/">
        <dli:dliObject>
            <dnetResourceIdentifier>
                <xsl:value-of select="//*[local-name()='header']/*[local-name()='objIdentifier']"/>
            </dnetResourceIdentifier>
            <localIdentifier type="openairePID">
                <xsl:value-of select="//*[local-name()='header']/*[local-name()='objIdentifier']" />
            </localIdentifier>
            <xsl:for-each select="//*[local-name()='entity']/*[local-name()='result']/*[local-name()='title']">
                <title>
                    <xsl:value-of select="."/>
                </title>
            </xsl:for-each> 
            <xsl:for-each select="//*[local-name()='result']/*[local-name()='dateofacceptance']">
            	<date>
                	<xsl:value-of select="."/>
            	</date>
            </xsl:for-each>                       
            <objectType><xsl:value-of select="//*[local-name()='entity']/*[local-name()='result']/*[local-name()='resulttype']/@classname" /></objectType>            
                <authors>
                    <xsl:for-each select=".//*[local-name()='fullname']">
                        <author>
                            <fullname> <xsl:value-of select="."/> </fullname>
                        </author>
                    </xsl:for-each>
                </authors>            
        </dli:dliObject>

    </xsl:template>
</xsl:stylesheet>
