<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
    exclude-result-prefixes="xsl datetime exslt dnet">
    
    <xsl:param name="repositoryId" />
    <xsl:param name="namespacePrefix"></xsl:param>
    <xsl:param name="dataprovider_id"></xsl:param>
    <xsl:param name="parentDatasourceId"></xsl:param>
    <xsl:variable name="status" select="/*[local-name() = 'record']/*[local-name() = 'header']/@status" />
    <xsl:variable name="doi" select="//*[local-name()='resource']/*[local-name()='identifier']"></xsl:variable>  
    <xsl:template match="/">
        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
           
            <oai:header> 
                <xsl:if test="//*[local-name()='resource']/*[local-name()='identifier']">
                    <dri:objIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($doi))"/></dri:objIdentifier>
                </xsl:if>               
                
                <dri:recordIdentifier><xsl:value-of select="$doi"/></dri:recordIdentifier>
                <dri:dateOfCollection><xsl:value-of select="datetime:dateTime()"/></dri:dateOfCollection>
                <dri:repositoryId><xsl:value-of select="$dataprovider_id"/></dri:repositoryId>
                <dri:datasourceprefix><xsl:value-of select="$namespacePrefix"/></dri:datasourceprefix>
                <dri:datasourceID><xsl:value-of select="$parentDatasourceId"/></dri:datasourceID>
                <!-- Bulk copy of old header -->
                <xsl:for-each select="/*[local-name() = 'record']/*[local-name() = 'header']//*[namespace-uri()='http://www.openarchives.org/OAI/2.0/']">
                    <xsl:copy-of select="." />
                </xsl:for-each>
            </oai:header>
            <xsl:choose>
                <xsl:when test="count(//*[local-name() = 'resource']) &gt; 0">
                    <metadata>
                        <xsl:copy-of select="//*[local-name() = 'resource']"/>
                    </metadata>
                </xsl:when>
            </xsl:choose>                     
        </oai:record>
    </xsl:template>    
</xsl:stylesheet>
