<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
    exclude-result-prefixes="xsl datetime exslt dnet">
    
    <xsl:param name="repositoryId" />
    <xsl:param name="namespacePrefix"></xsl:param>
    <xsl:param name="dataprovider_id"></xsl:param>
    <xsl:variable name="status" select="/*[local-name() = 'record']/*[local-name() = 'header']/@status" />
     <xsl:variable name="pid" select="//*[local-name()='localIdentifier']"></xsl:variable>  
    <xsl:variable name="related_pid" select="//*[local-name()='relation']/*[local-name()='pid']"></xsl:variable>  
    <xsl:template match="/">
        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">           
            <oai:header> 
                <dri:objIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($pid),'::',dnet:md5($related_pid))"/></dri:objIdentifier>
                <dri:recordIdentifier><xsl:value-of select="$pid"/></dri:recordIdentifier>
                <dri:dateOfCollection><xsl:value-of select="datetime:dateTime()"/></dri:dateOfCollection>
                <dri:repositoryId><xsl:value-of select="$dataprovider_id"/></dri:repositoryId>
                <dri:datasourceprefix><xsl:value-of select="$namespacePrefix"/></dri:datasourceprefix>               
            </oai:header>
            <xsl:choose>
                <xsl:when test="count(//*[local-name() = 'dliObject']) &gt; 0">
                    <metadata>
                        <xsl:copy-of select="//*[local-name() = 'dliObject']"/>
                    </metadata>
                </xsl:when>
            </xsl:choose>                     
        </oai:record>
    </xsl:template>    
</xsl:stylesheet>
