<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:datetime="http://exslt.org/dates-and-times"
				xmlns:exslt="http://exslt.org/common" xmlns:oai="http://www.openarchives.org/OAI/2.0/"
				xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:dli="http://www.dli.eu"
				version="1.0"
				exclude-result-prefixes="xsl datetime dnet exslt">
	<!--  " -->
	<xsl:param name="repositoryId"/>
	<xsl:param name="namespacePrefix"></xsl:param>
	<xsl:param name="dataprovider_id"></xsl:param>
	<xsl:param name="parentDatasourceId"></xsl:param>

	<xsl:variable name="id" select="//*[local-name()='column' and ./@isID='true']"></xsl:variable>
	<xsl:variable name="doitype" select="//*[local-name()='column' and ./@name='db']"></xsl:variable>
	<xsl:variable name="dnetId" select="concat($doitype,'::',$id)"></xsl:variable>
	<xsl:variable name="date" select="//*[local-name()='column' and ./@name='date']"></xsl:variable>
	<xsl:variable name="reldoi" select="//*[local-name()='column' and ./@name='ArticleID']"></xsl:variable>
	<xsl:template match="/">
		<oai:record xmlns:dc="http://purl.org/dc/elements/1.1/"
					xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
					xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
					xmlns="http://namespace.openaire.eu/">

			<oai:header>
				<xsl:if test=" string-length(normalize-space($id)) &gt; 0">
					<dri:objIdentifier>
						<xsl:value-of select="concat($parentDatasourceId,'::', dnet:md5($dnetId),'::', dnet:md5($reldoi))"/>
					</dri:objIdentifier>
				</xsl:if>

				<dri:recordIdentifier>
					<xsl:value-of select="$id"/>
				</dri:recordIdentifier>
				<dri:dateOfCollection>
					<xsl:value-of select="datetime:dateTime()"/>
				</dri:dateOfCollection>
				<dri:repositoryId>
					<xsl:value-of select="$dataprovider_id"/>
				</dri:repositoryId>
				<dri:datasourceprefix>
					<xsl:value-of select="$namespacePrefix"/>
				</dri:datasourceprefix>
			</oai:header>
			<metadata>
				<dli:dliObject>
					<dnetResourceIdentifier>
						<xsl:value-of select="concat($parentDatasourceId,'::', dnet:md5($dnetId),'::', dnet:md5($reldoi))"/>
					</dnetResourceIdentifier>
					<localIdentifier>
						<xsl:attribute name="type">
							<xsl:value-of select="$doitype"/>
						</xsl:attribute>
						<xsl:value-of select="$id"/>
					</localIdentifier>
					<objectType>dataset</objectType>
					<date>
						<xsl:value-of select="$date"></xsl:value-of>
					</date>
					<provenance>
						<datasource completionStatus="incomplete" provisionMode="collected">
							<xsl:value-of select="$parentDatasourceId"/>
						</datasource>
					</provenance>
					<completionStatus>incomplete</completionStatus>
					<relations>
						<relation>
							<pid type="doi">
								<xsl:value-of select="$reldoi"/>
							</pid>
							<typeOfRelation>unknown</typeOfRelation>
						</relation>
					</relations>
				</dli:dliObject>
			</metadata>
		</oai:record>
	</xsl:template>
</xsl:stylesheet>
