<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"    
    xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
    xmlns:dli="http://www.dli.eu"
    exclude-result-prefixes="xsl datetime dnet exslt">
    <!--  " -->  
    <xsl:param name="repositoryId" />
    <xsl:param name="namespacePrefix"></xsl:param>
    <xsl:param name="dataprovider_id"></xsl:param>
    
    
    <xsl:variable name="doi" select="//*[local-name()='column' and ./@isID='true']"></xsl:variable>        
    <xsl:variable name="reldoi" select="//*[local-name()='column' and ./@name='doi']"></xsl:variable>
    <xsl:variable name="relpmc" select="//*[local-name()='column' and ./@name='pmc']"></xsl:variable>
    <xsl:variable name="relpubmed" select="//*[local-name()='column' and ./@name='pubmedId']"></xsl:variable>
    
    <xsl:variable name="relationID">
    <xsl:choose>
    	<xsl:when test="string-length(normalize-space($reldoi)) &gt; 0">
    		<xsl:value-of select="$reldoi" />	
    	</xsl:when>
    	<xsl:when test="string-length(normalize-space($relpmc)) &gt; 0">
    		<xsl:value-of select="$relpmc" />
    	</xsl:when>
    	<xsl:when test="string-length(normalize-space($relpubmed)) &gt; 0">
    		<xsl:value-of select="$relpubmed" />
    	</xsl:when>
    	<xsl:otherwise>
    	
    	</xsl:otherwise>    
    </xsl:choose>    
    </xsl:variable>
    
    <xsl:variable name="relationIDType">
    <xsl:choose>
    	<xsl:when test="string-length(normalize-space($reldoi)) &gt; 0">doi</xsl:when>
    	<xsl:when test="string-length(normalize-space($relpmc)) &gt; 0">pmcId</xsl:when>
    	<xsl:when test="string-length(normalize-space($relpubmed)) &gt; 0">pubmedId</xsl:when>
    	<xsl:otherwise>
    	
    	</xsl:otherwise>
    
    </xsl:choose>
    
    </xsl:variable>
    
    
    
    
    
    <xsl:template match="/">
        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
            
            <oai:header> 
                <xsl:if test="string-length(normalize-space($relationID)) &gt; 0">
                    <dri:objIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($doi),'::',dnet:md5($relationID))"/></dri:objIdentifier>
                </xsl:if>               
                
                <dri:recordIdentifier><xsl:value-of select="$doi"/></dri:recordIdentifier>
                <dri:dateOfCollection><xsl:value-of select="datetime:dateTime()"/></dri:dateOfCollection>
                <dri:repositoryId><xsl:value-of select="$dataprovider_id"/></dri:repositoryId>
                <dri:datasourceprefix><xsl:value-of select="$namespacePrefix"/></dri:datasourceprefix>                
            </oai:header>
            <metadata>
                <dli:dliObject>
                    <dnetResourceIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($doi),'::',dnet:md5($relationID))"/></dnetResourceIdentifier>
                    <localIdentifier type="pdb">                        
                        <xsl:value-of select="$doi"/>
                    </localIdentifier>               
                    <objectType>dataset</objectType>
                    <provenance>
         				<datasource completionStatus="complete" provisionMode="collected"><xsl:value-of select="$namespacePrefix"/></datasource>
         			</provenance>
         			<completionStatus>complete</completionStatus>
         			
         			<title><xsl:value-of select="//*[local-name()='column' and ./@name='structureTitle']"></xsl:value-of></title>         			
         			<date><xsl:value-of select="//*[local-name()='column' and ./@name='releaseDate']"></xsl:value-of></date>
         			<authors>
         			<xsl:for-each select="tokenize(//*[local-name()='column' and ./@name='structureAuthor'],'#')">
         				<author>
         					<fullname>
         						<xsl:value-of select="."></xsl:value-of>
         					</fullname>
         				</author>         			
         			</xsl:for-each>
         			</authors>
         			
                    
                    <relations>
                    <xsl:if test="string-length(normalize-space($relationID)) &gt; 0">
                    	<relation>
                            <pid><xsl:attribute name="type"> <xsl:value-of select="$relationIDType" /></xsl:attribute><xsl:value-of select="$relationID"/></pid>
                            <typeOfRelation>unknown</typeOfRelation>
                        </relation>
                	</xsl:if>             	
                    </relations>
                </dli:dliObject>                
            </metadata>           
        </oai:record>
    </xsl:template>    
</xsl:stylesheet>
