<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"    
    xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
    xmlns:dli="http://www.dli.eu"
    exclude-result-prefixes="xsl datetime dnet exslt">
    <!--  " -->  
    <xsl:param name="repositoryId" />
    <xsl:param name="namespacePrefix"></xsl:param>
    <xsl:param name="dataprovider_id"></xsl:param>
    <xsl:variable name="doi" select="//*[local-name()='column' and ./@isID='true']"></xsl:variable>        
    <xsl:template match="/">
        <oai:record xmlns="http://namespace.openaire.eu/"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:prov="http://www.openarchives.org/OAI/2.0/provenance"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
            <oai:header> 
                <dri:objIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($doi))"/></dri:objIdentifier>
                <dri:recordIdentifier><xsl:value-of select="$doi"/></dri:recordIdentifier>
                <dri:dateOfCollection><xsl:value-of select="datetime:dateTime()"/></dri:dateOfCollection>
                <dri:repositoryId><xsl:value-of select="$dataprovider_id"/></dri:repositoryId>
                <dri:datasourceprefix><xsl:value-of select="$namespacePrefix"/></dri:datasourceprefix>                
            </oai:header>
            <metadata>
                <dli:dliObject>
                    <dnetResourceIdentifier><xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($doi))"/></dnetResourceIdentifier>
                    <localIdentifier type="doi">                        
                        <xsl:value-of select="$doi"/>
                    </localIdentifier>             
                    <provenance>
                        <datasource completionStatus="incomplete" provisionMode="collected"><xsl:value-of select="$namespacePrefix"/></datasource>
                    </provenance>
                    <completionStatus>incomplete</completionStatus>
                </dli:dliObject>                
            </metadata>           
        </oai:record>
    </xsl:template>    
</xsl:stylesheet>
