<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainDataSourceParams">
	<DESCRIPTION>Fetch info from Datasource</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchCleaned"/>
	</ARCS>
</NODE> 

<NODE name="fetchCleaned" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("tran_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="cleanTempData"/>
	</ARCS>
</NODE>

<NODE name="cleanTempData" type="CleanTempData">
	<DESCRIPTION>Clean Temporary data from Database</DESCRIPTION>
	<PARAMETERS/>		
	<ARCS>
		<ARC to="aggregateObject"/>
	</ARCS>
</NODE>


<NODE name="aggregateObject" type="AggregateObject">
	<DESCRIPTION>Transform original records in multiple objects compliant with DLI format</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">transformed_epr</PARAM>
		<PARAM required="true" type="string" name="numberOfThread" managedBy="user" >2</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="upsertNewObject"/>
	</ARCS>
</NODE>


<NODE name="upsertNewObject" type="UpsertNewRecord">
	<DESCRIPTION>Upsert new DLI Object into Database</DESCRIPTION>
	<PARAMETERS/>		
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
