package eu.dnetlib.msro.dli.workflows.nodes.transform;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FetchDLIRecordJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchDLIRecordJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private DLIDBManager manager;

	private String outputEprParam;

	private String updateExported;

	private boolean exportIntersection;

	/** The result set factory. */
	@Resource(name = "iterableResultSetFactory")
	private IterableResultSetFactory resultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		log.info("start updating exported views");
		if ("true".equals(getUpdateExported())) {
			manager.updateExportedView();
		}
		log.info("updated, iterating on objects");
		W3CEndpointReference eprUrls = resultSetFactory.createIterableResultSet(manager.getAllRecord(exportIntersection));
		token.getEnv().setAttribute(getOutputEprParam(), eprUrls.toString());
		return Arc.DEFAULT_ARC;
	}

	/**
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return outputEprParam;
	}

	/**
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getUpdateExported() {
		return updateExported;
	}

	public void setUpdateExported(final String updateExported) {
		this.updateExported = updateExported;
	}

	public boolean isExportIntersection() {
		return exportIntersection;
	}

	public void setExportIntersection(final boolean exportIntersection) {
		this.exportIntersection = exportIntersection;
	}
}
