package eu.dnetlib.msro.dli.workflows.nodes.transform;

import eu.dnetlib.msro.dli.workflows.nodes.feeding.utility.DLIRecordParser;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.resolver.DOIResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

// TODO: Auto-generated Javadoc

/**
 * The Class DOIResolverWorker.
 */
public class DOIResolverWorker implements Callable<Boolean> {

    /**
     * The Constant log.
     */
    private static final Log log = LogFactory.getLog(DOIResolverWorker.class); // NOPMD by marko on 11/24/08 5:02 PM
    /**
     * The parser.
     */
    final DLIRecordParser parser;
    /**
     * The queue.
     */
    private final BlockingQueue<String> queue;
    /**
     * The queue.
     */
    private final BlockingQueue<DLIObject> outputqueue;
    /**
     * The doi resolvers.
     */
    private final List<DOIResolver> doiResolvers;
    /**
     * The terminator queue.
     */
    private final String terminatorQueue;

    /**
     * Instantiates a new DOI resolver worker.
     *
     * @param queue           the queue
     * @param outputqueue     the outputqueue
     * @param doiResolvers    the doi resolvers
     * @param terminatorQueue the terminator queue
     */
    public DOIResolverWorker(final BlockingQueue<String> queue, final BlockingQueue<DLIObject> outputqueue, final List<DOIResolver> doiResolvers,
                             final String terminatorQueue) {
        this.queue = queue;
        this.outputqueue = outputqueue;
        this.doiResolvers = doiResolvers;
        this.terminatorQueue = terminatorQueue;
        this.parser = new DLIRecordParser();
    }

    /*
     * (non-Javadoc)
     *
     * @see java.util.concurrent.Callable#call()
     */
    @Override
    public Boolean call() {
        String nextRecord = null;
        try {
            nextRecord = this.queue.take();
            if (nextRecord == this.terminatorQueue) {
                log.debug("Found terminator record");
                this.queue.put(terminatorQueue);
                return true;
            }
        } catch (InterruptedException e) {
            log.error("Error on taking an element on queue", e);
        }
        while ((nextRecord != null) && (nextRecord != terminatorQueue)) {
            try {
                DLIObject object = parser.parseRecord(nextRecord);

                boolean resolved = false;
                for (DOIResolver resolver : doiResolvers) {
                    DLIObject result = resolver.retrieveDOI(object.getPid(), object.getPidType());
                    if (result != null) {
                        // result.setDatasources(object.getDatasources());
                        result.setRelations(object.getRelations());
                        outputqueue.put(result);
                        resolved = true;
                        break;
                    }
                }
                if (resolved == false) {
                    outputqueue.put(object);
                }
            } catch (Exception e) {
                log.error("Error on resolving record" + nextRecord, e);
            }
            try {
                nextRecord = this.queue.take();
                if (nextRecord == this.terminatorQueue) {
                    this.queue.put(terminatorQueue);
                }
            } catch (InterruptedException e) {
                log.error("Error on getting element on queue");
            }
        }
        return true;
    }
}
