package eu.dnetlib.msro.dli.workflows.nodes.transform;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import org.apache.commons.lang.StringUtils;

public class DLIUtils {

    private static BiMap<String, String> relations;

    private static BiMap<String, String> getRelationMap() {

        if (relations == null) {
            relations = HashBiMap.create();
            relations.put("IsCitedBy", "Cites");
            relations.put("IsSupplementTo", "IsSupplementedBy");
            relations.put("IsReferencedBy", "References");
        }
        return relations;
    }


    public static String fixPID(String input) {
        if (input != null) {
            return input.replace("http://dx.doi.org/", "").replace("http://doi.org/", "");
        }
        return input;
    }

    public static String getInverse(final String relation) {
        BiMap<String, String> relMap = getRelationMap();

        for (String s : relMap.keySet()) {
            if (s.toLowerCase().trim().equals(relation.toLowerCase().trim())) return relMap.get(s);
        }
        for (String s : relMap.inverse().keySet()) {
            if (s.toLowerCase().trim().equals(relation.toLowerCase().trim())) return relMap.inverse().get(s);
        }
        return "unknown";
    }

    public static String generateIdentifier(final String pid, final String pidtype) {
        if (StringUtils.isBlank(pid) || StringUtils.isBlank(pidtype))
            throw new RuntimeException("Error pid or pidtype cannot be null");
        return DnetXsltFunctions.md5(String.format("%s::%s", pid.trim(), pidtype.toLowerCase().trim()));
    }
}
