/**
 *
 */
package eu.dnetlib.msro.dli.workflows.nodes.transform;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;



/**
 * The Class CleanTempDataJobNode.
 *
 * @author sandro
 */
public class CleanTempDataJobNode extends SimpleJobNode {


	/** The manager. */
	@Autowired
	private DLIDBManager manager;

	/**
	 * {@inheritDoc}
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {
		manager.dropTemporaryData();
		return Arc.DEFAULT_ARC;
	}

}
