package eu.dnetlib.msro.dli.workflows.nodes.store;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.dli.objectstore.DLIObjectStore;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Sandro La Bruzzo on 12/9/15.
 */
public class StoreDLIObjectJobNode extends SimpleJobNode implements ProgressJobNode {


    @Autowired
    DLIDBManager manager;


    @Autowired
    DLIObjectStore store;


    @Override
    protected String execute(NodeToken token) throws Exception {
        final Iterable<DLIObject> objectRecord = manager.getAllDLIObjectRecord(false, true);
        store.feedStore(objectRecord);
        return Arc.DEFAULT_ARC;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return new ProgressProvider() {
            @Override
            public int getTotalValue() {
                return -1;
            }

            @Override
            public int getCurrentValue() {
                return store.getTotalItem();
            }

            @Override
            public boolean isInaccurate() {
                return true;
            }
        };
    }
}
