package eu.dnetlib.msro.dli.workflows.nodes.resolver;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.dli.workflows.nodes.transform.DOIResolverWorker;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.resolver.DOIResolver;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class ResolvingHarvestedPidJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(ResolvingHarvestedPidJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final DLIObject END_QUEUE = new DLIObject();

	private String inputEprParam;

	private String outputEprParam;

	/** The result set client factory. */
	@Autowired
	private ResultSetClientFactory resultSetClientFactory;

	@Autowired
	List<DOIResolver> doiResolvers;

	private StringTemplate xmlTemplate;

	/** The result set factory. */
	@javax.annotation.Resource(name = "iterableResultSetFactory")
	private IterableResultSetFactory resultSetFactory;

	/** The number of thread. */
	private int numberOfThread = 4;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(getInputEprParam()));
		final Iterable<String> input = resultSetClientFactory.getClient(inputEpr);
		final ExecutorService executor = Executors.newFixedThreadPool(getNumberOfThread());
		final List<Future<Boolean>> responses = Lists.newArrayList();
		final BlockingQueue<String> queue = new ArrayBlockingQueue<String>(1000);
		final BlockingQueue<DLIObject> outputqueue = new ArrayBlockingQueue<DLIObject>(10000);
		final String terminatorQueue = "END_QUEUE";
		for (int i = 0; i < numberOfThread; i++) {
			responses.add(executor.submit(new DOIResolverWorker(queue, outputqueue, doiResolvers, terminatorQueue)));
		}

		new Thread(new Runnable() {

			@Override
			public void run() {

				for (String s : input) {

					try {

						queue.put(s);
					} catch (InterruptedException e) {
						log.error("Error on inserting element on queue", e);
					}
				}
				try {
					queue.put(terminatorQueue);
				} catch (InterruptedException e) {
					log.error("Error on inserting element on queue", e);
				}
				try {
					for (Future<Boolean> response : responses) {
						log.info("Thread terminated correctly" + response.get());

					}
					outputqueue.put(END_QUEUE);
				} catch (Exception e) {
					log.error(e);
				}

			}
		}).start();

		W3CEndpointReference eprUrls = resultSetFactory.createIterableResultSet(new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new DLIObjectIteratorQueue(outputqueue, END_QUEUE, xmlTemplate);
			}
		});
		token.getEnv().setAttribute(getOutputEprParam(), eprUrls.toString());

		// final DLIRecordParser parser = new DLIRecordParser();
		// Iterable<String> extractedObject = Iterables.transform(input, new Function<String, String>() {
		//
		// @Override
		// public String apply(final String input) {
		// DLIObject object = parser.parseRecord(input);
		//
		// for (DOIResolver resolver : doiResolvers) {
		// DLIObject result = resolver.retrieveDOI(object.getPid());
		// result.setDatasources(object.getDatasources());
		// if (result != null) {
		// result.setRelations(object.getRelations());
		// xmlTemplate.removeAttribute("object");
		// xmlTemplate.setAttribute("object", result);
		// return xmlTemplate.toString();
		// }
		// }
		// return input;
		// }
		// });
		// W3CEndpointReference eprUrls = resultSetFactory.createIterableResultSet(extractedObject);
		// token.getEnv().setAttribute(getOutputEprParam(), eprUrls.toString());
		return Arc.DEFAULT_ARC;
	}

	/**
	 * @return the inputEprParam
	 */
	public String getInputEprParam() {
		return inputEprParam;
	}

	/**
	 * @param inputEprParam
	 *            the inputEprParam to set
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	/**
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return outputEprParam;
	}

	/**
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	@Required
	public void setTemplate(final Resource template) throws IOException {
		xmlTemplate = new StringTemplate(IOUtils.toString(template.getInputStream()));
	}

	/**
	 * @return the numberOfThread
	 */
	public int getNumberOfThread() {
		return numberOfThread;
	}

	/**
	 * @param numberOfThread
	 *            the numberOfThread to set
	 */
	public void setNumberOfThread(final int numberOfThread) {
		this.numberOfThread = numberOfThread;
	}

}
