package eu.dnetlib.msro.dli.workflows.nodes.resolver;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;

import org.antlr.stringtemplate.StringTemplate;

import eu.dnetlib.msro.workflows.dli.model.DLIObject;

/**
 * The Class DLIObjectIteratorQueue.
 */
public class DLIObjectIteratorQueue implements Iterator<String> {

	/** The queue. */
	private final BlockingQueue<DLIObject> queue;

	/** The terminator. */
	private final DLIObject terminator;

	/** The template. */
	private final StringTemplate template;

	/** The next object. */
	private String nextObject;

	/**
	 * Instantiates a new DLI object iterator queue.
	 *
	 * @param inputQueue
	 *            the input queue
	 * @param terminator
	 *            the terminator
	 * @param inputTemplate
	 *            the input template
	 */
	public DLIObjectIteratorQueue(final BlockingQueue<DLIObject> inputQueue, final DLIObject terminator, final StringTemplate inputTemplate) {
		this.queue = inputQueue;
		this.terminator = terminator;
		this.template = inputTemplate;
		nextObject = getNext();
	}

	/**
	 * Gets the next.
	 *
	 * @return the next
	 */
	private String getNext() {
		try {
			DLIObject obj = this.queue.take();
			if (obj == this.terminator) { return null; }
			template.removeAttribute("object");
			template.setAttribute("object", obj);
			return template.toString();
		} catch (InterruptedException e) {
			return null;
		}
	}

	/**
	 * Checks for next.
	 *
	 * @return true, if successful
	 */
	@Override
	public boolean hasNext() {
		return nextObject != null;
	}

	/**
	 * Next.
	 *
	 * @return the string
	 */
	@Override
	public String next() {
		String tmp = nextObject;
		nextObject = getNext();
		return tmp;
	}

	/**
	 * Removes the.
	 */
	@Override
	public void remove() {
		throw new RuntimeException("Not implemented method");

	}

}
