/**
 *
 */
package eu.dnetlib.msro.dli.workflows.nodes.pidresolving;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.dli.model.DLICompletionStatus;
import eu.dnetlib.msro.workflows.dli.model.DLIObject;
import eu.dnetlib.msro.workflows.dli.resolver.DOIResolver;
import eu.dnetlib.msro.workflows.dli.resolver.WorkerResolver;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.concurrent.*;

/**
 * @author sandro
 */
public class ResolvePIDJobNode extends SimpleJobNode implements ProgressProvider, ProgressJobNode {

    private static final Log log = LogFactory.getLog(ResolvePIDJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

    private int currentPosition = 0;

    @Autowired
    private DLIDBManager manager;

    @Autowired
    private List<DOIResolver> doiResolvers;

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
     */
    @Override
    protected String execute(final NodeToken token) throws Exception {

        Iterable<DLIObject> input = manager.getUnresolvedRecords();

        final ExecutorService executor = Executors.newFixedThreadPool(10);
        final BlockingQueue<DLIObject> inputQueue = new ArrayBlockingQueue<DLIObject>(100);
        final List<Future<Boolean>> responses = Lists.newArrayList();
        currentPosition = 0;
        for (int i = 0; i < 5; i++) {
            responses.add(executor.submit(new WorkerResolver(doiResolvers, inputQueue, i, manager)));
        }

        for (DLIObject obj : input) {
            currentPosition++;
            obj.setCompletionStatus(DLICompletionStatus.incomplete.toString());
            try {
                inputQueue.put(obj);

            } catch (Exception e) {
                log.error("Error on put object on queue", e);
            }
        }

        inputQueue.put(WorkerResolver.END_QUEUE);

        for (Future<Boolean> response : responses) {
            response.get();
        }

        return Arc.DEFAULT_ARC;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.util.ProgressProvider#getTotalValue()
     */
    @Override
    public int getTotalValue() {
        return -1;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.util.ProgressProvider#getCurrentValue()
     */
    @Override
    public int getCurrentValue() {
        return currentPosition;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.util.ProgressProvider#isInaccurate()
     */
    @Override
    public boolean isInaccurate() {
        return true;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.nodes.ProgressJobNode#getProgressProvider()
     */
    @Override
    public ProgressProvider getProgressProvider() {
        // TODO Auto-generated method stub
        return this;
    }

}
