package eu.dnetlib.msro.dli.workflows.nodes.intersection;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CleanOldPIDJobNode extends SimpleJobNode {

	@Autowired
	private DLIDBManager dbManager;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		String datasourcePrefix = token.getEnv().getAttribute("namespacePrefix");
		if (datasourcePrefix != null) {
			dbManager.deleteOldPid(datasourcePrefix);
		} else throw new Exception("datasourcePrefix is missing in the Environement");
		return Arc.DEFAULT_ARC;
	}

}
