package eu.dnetlib.msro.dli.workflows.nodes.index;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindIndexJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(FindIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	/**
	 * if non null, overrides format from env.
	 */
	private String mdFormat;

	/**
	 * if non null, overrides format from env.
	 */
	private String layout;

	/**
	 * if non null, overrides format from env.
	 */
	private String interpretation;

	/**
	 * {@inheritDoc}
	 * 
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) {
		final String envFormat = token.getFullEnv().getAttribute("format");
		final String envLayout = token.getFullEnv().getAttribute("layout");
		final String envInterpretation = token.getFullEnv().getAttribute("interpretation");

		final String format = handleOverride(token, "format", envFormat, getMdFormat());
		final String layout = handleOverride(token, "layout", envLayout, getLayout());
		final String interp = handleOverride(token, "interpretation", envInterpretation, getInterpretation());

		String mdRef = format + "-" + layout + "-" + interp;
		log.info("searching index for [" + mdRef + "]");

		final String indexId = findIndex(format, layout, interp);
		token.getEnv().setAttribute("index_id", indexId);

		if (indexId == null || indexId.isEmpty()) {
			log.info("no index was found for [" + mdRef + "]");
			return "notFound";
		} else {
			log.info("index found for [" + mdRef + "]: " + indexId);
			return "found";
		}
	}

	private String findIndex(final String format, final String layout, final String interp) {
		final String xquery =
				"for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType']" + "return $x[.//METADATA_FORMAT = '" + format
						+ "' and .//METADATA_FORMAT_LAYOUT='" + layout + "' and .//METADATA_FORMAT_INTERPRETATION = '" + interp
						+ "']//RESOURCE_IDENTIFIER/@value/string()";
		try {
			log.info("xquery: " + xquery);
			List<String> ids = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
			log.info("found indexDS ids: " + ids);
			if (ids == null || ids.isEmpty()) { return null; }
			if (ids.size() > 1) { throw new IllegalStateException("found more than one index of given format: " + format + ", layout: " + layout
					+ ", interpretation: " + interp); }
			return Iterables.getOnlyElement(ids);
		} catch (Exception e) {
			return null;
		}
	}

	private String handleOverride(final NodeToken token, final String name, final String env, final String override) {
		if (override != null) {
			token.getEnv().setAttribute(name, override);
		}
		return override != null ? override : env;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

}
