package eu.dnetlib.msro.dli.workflows.nodes.feeding.utility;

import com.google.common.collect.Lists;
import eu.dnetlib.msro.workflows.dli.model.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Stack;

/**
 * This method outperforms SimpleRecordParser by a vast amount, especially since we are just getting stuff in the header.
 *
 * @author sandro
 */
public class DLIRecordParser {

    private static final Log log = LogFactory.getLog(DLIRecordParser.class); // NOPMD by marko on 11/24/08 5:02 PM

    public DLIObject parseRecord(final String record) {

        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(new ByteArrayInputStream(record.getBytes()));

            DLIObject object = new DLIObject();
            Stack<String> elementStack = new Stack<String>();
            elementStack.push("/");
            List<String> titles = Lists.newArrayList();
            List<String> authors = Lists.newArrayList();
            boolean insideRelation = false;
            DLIRelation currentRelation = null;
            List<DLIRelation> relations = Lists.newArrayList();
            List<DLIProvenance> datasources = Lists.newArrayList();

            while (parser.hasNext()) {
                int event = parser.next();
                if (event == XMLStreamConstants.END_ELEMENT) {
                    final String localName = parser.getLocalName();

                    // CLOSE TAG relation
                    if (localName.equals("relation")) {
                        log.debug("found closed tag relation");
                        insideRelation = false;
                        if (currentRelation != null) {
                            if (object.getPid() == null || object.getPid().isEmpty()) {
                                log.error("ERROR the DOI is empty");
                            }
                            currentRelation.setSourcePid(object.getPid());
                            if (!StringUtils.isBlank(object.getPid()) && !StringUtils.isBlank(object.getPidType())) {
                                currentRelation.setSourceRecordId(object.getIdentifier());
                            }

                            log.debug("Adding new relation to the object");
                            relations.add(currentRelation);
                            currentRelation = null;
                        }
                    }
                    elementStack.pop();
                } else if (event == XMLStreamConstants.START_ELEMENT) {
                    final String localName = parser.getLocalName();
                    elementStack.push(localName);

                    // LOCAL IDENTIFIER TAG
                    if ("localIdentifier".equals(localName)) {
                        log.debug("found open tag localIdentifier");
                        String type = "";
                        for (int i = 0; i < parser.getAttributeCount(); i++) {
                            if (parser.getAttributeLocalName(i).equals("type")) {
                                type = parser.getAttributeValue(i);
                                break;
                            }
                        }
                        parser.next();
                        if (parser.hasText()) {
                            object.setPid(parser.getText().trim());
                            object.setPidType(type);
                        }
                        // TITLE TAG
                    } else if ("title".equals(localName)) {
                        log.debug("found open tag title");
                        parser.next();
                        if (parser.hasText()) {
                            titles.add(parser.getText().trim());
                        }
                        // DATASOURCE PROVENANCE TAG
                    } else if ("datasource".equals(localName)) {

                        String completionStatus = "";
                        String provisionMode = "";
                        log.debug("found open tag datasources");
                        for (int i = 0; i < parser.getAttributeCount(); i++) {
                            if (parser.getAttributeLocalName(i).equals("completionStatus")) {
                                completionStatus = parser.getAttributeValue(i);
                            } else if (parser.getAttributeLocalName(i).equals("provisionMode")) {
                                provisionMode = parser.getAttributeValue(i);
                            }
                        }
                        parser.next();
                        if (parser.hasText()) {
                            String dt = parser.getText().trim();

                            DLIProvenance pr = new DLIProvenance(dt, DLIProvisionMode.fromString(provisionMode).toString(),
                                    DLICompletionStatus.fromString(completionStatus).toString(), null, null, true);
                            datasources.add(pr);
                        }
                        // INSIDE the tag Person
                    } else if ("completionStatus".equals(localName)) {
                        log.debug("found open tag completionStatus");
                        parser.next();
                        if (parser.hasText()) {
                            object.setCompletionStatus(DLICompletionStatus.fromString(parser.getText().trim()).toString());
                        }
                    } else if ("fullname".equals(localName)) {
                        log.debug("found open tag fullname");
                        parser.next();
                        if (parser.hasText()) {
                            authors.add(parser.getText().trim());
                        }

                        // INSIDE THE TAG RELATION
                    } else if ("relation".equals(localName)) {
                        log.debug("found open tag relation");
                        insideRelation = true;
                        currentRelation = new DLIRelation();
                    } else if ("pid".equals(localName) && insideRelation) {
                        DLIPID currentPid = new DLIPID();
                        for (int i = 0; i < parser.getAttributeCount(); i++) {
                            if (parser.getAttributeLocalName(i).equals("type")) {
                                currentPid.setType(parser.getAttributeValue(i));
                                break;
                            }
                        }

                        try {
                            parser.next();
                            if (parser.hasText()) {
                                currentPid.setId(parser.getText().trim());
                                currentRelation.setTargetPID(currentPid);
                            }

                        } catch (Exception e) {
                            log.error("skipped doi");
                        }
                        // INSIDE THE TAG TYPEOFRELATION
                    } else if ("typeOfRelation".equals(localName) && insideRelation) {
                        log.debug("found open tag typeOfRelation");
                        parser.next();
                        if (parser.hasText()) {
                            currentRelation.setRelationSemantics(parser.getText().trim());
                        }
                        // INSIDE THE TAG OBJECT TYPE
                    } else if ("objectType".equals(localName)) {
                        log.debug("found open tag objectType");
                        parser.next();
                        if (parser.hasText()) {
                            object.setType(DLIObjectType.valueOf(parser.getText().trim()));
                        }

                        // INSIDE THE TAG DATE
                    } else if ("date".equals(localName)) {
                        log.debug("found open tag date");
                        parser.next();
                        if (parser.hasText()) {
                            object.setDate(parser.getText().trim());
                        }
                    }
                }
            }
            object.setAuthors(authors.toArray(new String[0]));
            object.setTitles(titles.toArray(new String[0]));
            object.setDatasourceProvenance(datasources);
            object.setRelations(relations);
            return object;
        } catch (Exception e) {
            log.error("Error on parsing record" + record, e);
            return null;
        }

    }

}
