package eu.dnetlib.msro.dli.workflows.nodes.feeding;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.dli.workflows.nodes.feeding.utility.DLIRecordParser;
import eu.dnetlib.msro.dli.workflows.nodes.transform.DLIUtils;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.dli.publisher.PublisherResolver;
import eu.dnetlib.msro.workflows.dli.publisher.PublisherResolverFactory;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import java.util.List;
import java.util.concurrent.*;

/**
 * The Class AggregateObjectJobNode.
 */
public class AggregateObjectJobNode extends SimpleJobNode implements ProgressJobNode {

    /**
     * The Constant END_QUEUE.
     */
    private static final String END_QUEUE = "END_QUEUE";

    /**
     * The Constant log.
     */
    private static final Log log = LogFactory.getLog(AggregateObjectJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

    /**
     * The input epr param.
     */
    private String inputEprParam;

    /**
     * The output epr param.
     */
    private String outputEprParam;

    /**
     * The number of thread.
     */
    private int numberOfThread = 1;

    /**
     * The input blocking queue.
     */
    private BlockingQueue<String> inputBlockingQueue;


    @Autowired
    PublisherResolverFactory publisherResolverFactory;

    /**
     * The result set client factory.
     */
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;

    /**
     * The result set factory.
     */
    @Resource(name = "iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;

    /**
     * The manager.
     */
    @Autowired
    private DLIDBManager manager;



    /**
     * The added elemtents.
     */
    private int addedElemtents = 0;

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
     */
    @Override
    protected String execute(final NodeToken token) throws Exception {
        final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(inputEprParam));
        DLIUtils.getInverse("references");
        Iterable<String> input = resultSetClientFactory.getClient(inputEpr);
        inputBlockingQueue = new ArrayBlockingQueue<String>(1000);
        final List<Future<Boolean>> responses = Lists.newArrayList();
        final ExecutorService executor = Executors.newFixedThreadPool(numberOfThread);
        final String datasourceId = token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID);
        PublisherResolver resolver = publisherResolverFactory.getInstance(datasourceId);
        String nameSpacePrefix = token.getEnv().getAttribute("parentDatasourceId");
        responses.add(executor.submit(new DatabaseFeederWorker(inputBlockingQueue, new DLIRecordParser(), manager, nameSpacePrefix, END_QUEUE, resolver)));



        int addedElements = 0;
        for (String s : input) {
            try {
                inputBlockingQueue.put(s);
                this.addedElemtents++;
                log.debug("Added " + addedElements);
            } catch (InterruptedException e) {
                log.error("Error on put item on blocking Queue.\n item:" + s, e);
            }
        }
        inputBlockingQueue.put(END_QUEUE);
        for (final Future<Boolean> reportThread : responses) {
            if (reportThread.get() == false) {
                log.error("Some Thread failed");
            }
            log.debug(reportThread.get());
        }
        return Arc.DEFAULT_ARC;
    }

    /**
     * Gets the input epr param.
     *
     * @return the inputEprParam
     */
    public String getInputEprParam() {
        return inputEprParam;
    }

    /**
     * Sets the input epr param.
     *
     * @param inputEprParam the inputEprParam to set
     */
    public void setInputEprParam(final String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    /**
     * Gets the output epr param.
     *
     * @return the outputEprParam
     */
    public String getOutputEprParam() {
        return outputEprParam;
    }

    /**
     * Sets the output epr param.
     *
     * @param outputEprParam the outputEprParam to set
     */
    public void setOutputEprParam(final String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    /**
     * Gets the number of thread.
     *
     * @return the numberOfThread
     */
    public int getNumberOfThread() {
        return numberOfThread;
    }

    /**
     * Sets the number of thread.
     *
     * @param numberOfThread the numberOfThread to set
     */
    public void setNumberOfThread(final int numberOfThread) {
        this.numberOfThread = numberOfThread;
    }

    /**
     * {@inheritDoc}
     *
     * @see eu.dnetlib.msro.workflows.nodes.ProgressJobNode#getProgressProvider()
     */
    @Override
    public ProgressProvider getProgressProvider() {
        return new ProgressProvider() {

            @Override
            public boolean isInaccurate() {
                return true;
            }

            @Override
            public int getTotalValue() {
                return -1;
            }

            @Override
            public int getCurrentValue() {
                return getAddedElemtents();
            }
        };
    }

    /**
     * Gets the added elemtents.
     *
     * @return the addedElemtents
     */
    public int getAddedElemtents() {
        return addedElemtents;
    }

    /**
     * Sets the added elemtents.
     *
     * @param addedElemtents the addedElemtents to set
     */
    public void setAddedElemtents(final int addedElemtents) {
        this.addedElemtents = addedElemtents;
    }
}
