package eu.dnetlib.msro.dli.workflows.nodes;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.functionality.modular.ui.stastdli.StatsStore;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class StoreStatsJobNode extends SimpleJobNode {

	@Autowired
	private StatsStore statsStore;

	@Autowired
	private DLIDBManager manager;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		statsStore.storeStats(new Date(), manager.getStats());
		return Arc.DEFAULT_ARC;
	}

}
