package eu.dnetlib.msro.dli.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareOAIParametersJobNode extends SimpleJobNode {

	private String format;
	private String layout;
	private String interpretation;
	private String db_name;
	
	
	@Override
	protected String execute(final NodeToken token) throws Exception {
		token.getEnv().setAttribute("oai_format", format);
		token.getEnv().setAttribute("oai_layout", layout);
		token.getEnv().setAttribute("oai_interpretation", interpretation);
		token.getEnv().setAttribute("oai_recordSource", "dli");
		token.getEnv().setAttribute("oai_dbName", getDb_name());
		return Arc.DEFAULT_ARC;
	}

	/**
	 * @return the format
	 */
	public String getFormat() {
		return format;
	}

	/**
	 * @param format
	 *            the format to set
	 */
	public void setFormat(final String format) {
		this.format = format;
	}

	/**
	 * @return the layout
	 */
	public String getLayout() {
		return layout;
	}

	/**
	 * @param layout
	 *            the layout to set
	 */
	public void setLayout(final String layout) {
		this.layout = layout;
	}

	/**
	 * @return the interpretation
	 */
	public String getInterpretation() {
		return interpretation;
	}

	/**
	 * @param interpretation
	 *            the interpretation to set
	 */
	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getDb_name() {
		return db_name;
	}

	public void setDb_name(String db_name) {
		this.db_name = db_name;
	}

	

}
