package eu.dnetlib.msro.dli.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.Resource;

public class ObtainDataSourceParamsJobNode extends SimpleJobNode {


    private static final Log log = LogFactory.getLog(ObtainDataSourceParamsJobNode.class);
    private String providerId;

    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(final NodeToken token) throws Exception {
        final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + providerId + "']//EXTRA_FIELDS\n"
                + "return concat($x/FIELD[./key='DataSourceId']/value, ' @@@ ', $x/FIELD[./key='NamespacePrefix']/value)";

        final String[] arr = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query).split("@@@");

        token.getEnv().setAttribute("parentDatasourceId", arr[0].trim());
        token.getEnv().setAttribute("namespacePrefix", arr[1].trim());
        token.getEnv().setAttribute("dateOfCollection", DateUtils.now_ISO8601());

        log.info(WorkflowsConstants.DATAPROVIDER_ID + " : " + token.getFullEnv().getAttribute(WorkflowsConstants.DATAPROVIDER_ID));

        return Arc.DEFAULT_ARC;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(final String providerId) {
        this.providerId = providerId;
    }

}
