package eu.dnetlib.functionality.modular.ui.stastdli;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Maps.EntryTransformer;
import com.mongodb.*;
import eu.dnetlib.msro.workflows.dli.manager.StatsInfo;
import org.springframework.beans.factory.annotation.Required;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * The Class StatsStore.
 */
public class StatsStore {

    /**
     * The db.
     */
    private DB db;

    private String collectionName;

    /**
     * Store stats.
     *
     * @param statsDate    the stats date
     * @param currentStats the current stats
     */
    public void storeStats(final Date statsDate, final Map<String, StatsInfo> currentStats) {
        DBCollection collection = db.getCollection(getCollectionName());

        EntryTransformer<String, StatsInfo, BasicDBObject> transformer = new EntryTransformer<String, StatsInfo, BasicDBObject>() {

            @Override
            public BasicDBObject transformEntry(final String key, final StatsInfo value) {

                BasicDBObject obj = new BasicDBObject().append("Datasets", value.getNumberOfDatasets()).append("Publications", value.getNumberOfPublication())
                        .append("total", value.getNumberOfObjects()).append("links", value.getNumberOfRelations()).append("repository", key).append("acronym", value.getAcronym());
                return obj;
            }
        };
        Map<String, BasicDBObject> toStore = Maps.transformEntries(currentStats, transformer);

        BasicDBObject object = new BasicDBObject().append("date", statsDate);

        BasicDBObject stats = new BasicDBObject();
        for (String key : toStore.keySet()) {
            stats.append(key, toStore.get(key));
        }
        object.append("stats", stats);
        collection.save(object);

    }

    public List<StatsInfo> getLastStats() {

        DBCollection collection = db.getCollection(getCollectionName());
        DBCursor cursor = collection.find().sort(new BasicDBObject().append("date", -1)).limit(1);

        List<StatsInfo> result = Lists.newArrayList();

        if (cursor.hasNext()) {
            DBObject obj = cursor.next();
            if (obj.containsField("stats")) {
                BasicDBObject stats = (BasicDBObject) obj.get("stats");
                for (String key : stats.keySet()) {

                    result.add(StatsInfo.fromMongoObject(key, (DBObject) stats.get(key)));
                }

            }
            return result;

        }

        return null;

    }

    public Map<Date, List<StatsInfo>> getAllStats() {
        DBCollection collection = db.getCollection(getCollectionName());
        DBCursor cursor = collection.find();

        Map<Date, List<StatsInfo>> result = Maps.newHashMap();

        while (cursor.hasNext()) {
            BasicDBObject item = (BasicDBObject) cursor.next();

            if (item.containsField("date")) {
                Date dateOfCollection = item.getDate("date");
                List<StatsInfo> currentStats = Lists.newArrayList();
                if (item.containsField("stats")) {
                    BasicDBObject stats = (BasicDBObject) item.get("stats");
                    for (String key : stats.keySet()) {

                        currentStats.add(StatsInfo.fromMongoObject(key, (DBObject) stats.get(key)));
                    }
                    result.put(dateOfCollection, currentStats);

                }

            }

        }

        return result;

    }

    /**
     * Gets the db.
     *
     * @return the db
     */
    public DB getDb() {
        return db;
    }

    /**
     * Sets the db.
     *
     * @param db the new db
     */
    @Required
    public void setDb(final DB db) {
        this.db = db;
    }

    public String getCollectionName() {
        return collectionName;
    }

    @Required
    public void setCollectionName(final String collectionName) {
        this.collectionName = collectionName;
    }
}
