package eu.dnetlib.functionality.modular.ui.stastdli;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.google.common.collect.Lists;

import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.dli.manager.StatsInfo;

@Controller
public class StatsDLIInternalController {

	@Autowired
	private DLIDBManager manager;

	@Autowired
	private StatsStore stats;

	private List<StatsInfo> currentStats;

	@RequestMapping(value = "/ui/stats/infostats.do")
	@ResponseBody
	public List<StatsInfo> Infostats(final ModelMap map) throws Exception {
		if (currentStats == null) {
			currentStats = Lists.newArrayList(manager.getStats().values());

		}
		return currentStats;
	}

	@RequestMapping(value = "/ui/stats/refreshInfostats.do")
	@ResponseBody
	public List<StatsInfo> RefreshInfostats(final ModelMap map) throws Exception {
		currentStats = Lists.newArrayList(manager.getStats().values());
		return currentStats;
	}

	@RequestMapping(value = "/ui/stats/getLastStats")
	@ResponseBody
	public List<StatsInfo> getLastInfostats(final ModelMap map) throws Exception {
		return stats.getLastStats();
	}

	@RequestMapping(value = "/ui/stats/getAllStats")
	@ResponseBody
	public Map<Date, List<StatsInfo>> getAllInfostats(final ModelMap map) throws Exception {
		return stats.getAllStats();
	}

}
