package eu.dnetlib.functionality.dli.datasource;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.stastdli.StatsStore;
import eu.dnetlib.msro.workflows.dli.manager.DLIDBManager;
import eu.dnetlib.msro.workflows.dli.manager.StatsInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Map;


@Controller
public class DLIDatasourceInfoController {

    private static final Log log = LogFactory.getLog(DLIDatasourceInfoController.class);

    @Autowired
    private DLIDBManager manager;

    @Autowired
    private StatsStore stats;


    @RequestMapping(value = "/ui/dli/datasource/datasources.do")
    @ResponseBody
    public List<DLIDatasourceInfo> listDatasources(final ModelMap map) {
        return manager.listDatasources();
    }


    @RequestMapping(value = "/ui/dli/datasource/info.do")
    @ResponseBody
    public DLIDatasourceInfo infoStats(final ModelMap map, @RequestParam(value = "id", required = false) final String datasourceID, @RequestParam(value = "name", required = false) final String datasourceName) throws Exception {

        final DLIDatasourceInfo result = getProfileDSInfo(datasourceID, datasourceName);
        if (result == null)
            return result;
        final Map<Date, List<StatsInfo>> allStats = stats.getAllStats();
        final Map<Date, StatsInfo> mapStats = Maps.newHashMap();
        result.setStats(mapStats);
        for (Date key : allStats.keySet()) {
            for (StatsInfo info : allStats.get(key)) {
                if (info.getDatasource().equals(result.getOfficialName())) {
                    mapStats.put(key, info);
                }
            }
        }
        result.setStats(mapStats);
        return result;


    }


    /**
     * This method find into the db all the infos relative
     * to a particular datasource with a given prefix name
     *
     * @param dataSourcePrefix the prefix of the datasource
     * @return the information of the datasource without stats
     */

    private DLIDatasourceInfo getProfileDSInfo(final String dataSourcePrefix, final String datasourceName) {
        if (dataSourcePrefix != null || datasourceName != null)
            return manager.getDataSourceInfo(datasourceName, dataSourcePrefix);
        return null;
    }


    private List<DLIDatasourceInfo> retrieveListOfDataSources() {
        return null;
    }


}
