/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.blacklist;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenaireIdResolver {
    public static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";
    private static final Log log = LogFactory.getLog(OpenaireIdResolver.class);
    private static final String RESULT_FIELD = "__result";
    private static final String XPATH_TO_MERGED = "//*[local-name()='entity']/*//children/result/@objidentifier";
    private final SAXReader saxReader = new SAXReader();
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public List<String> resolveIdentifier(String id) {
        if (StringUtils.isBlank((String)id)) {
            return Lists.newArrayList();
        }
        return this.findOriginalIds(id);
    }

    protected List<String> findOriginalIds(String id) {
        CloudSolrServer solrCore = null;
        SolrQuery q = new SolrQuery("objidentifier:\"" + id + "\"");
        QueryResponse response = null;
        try {
            solrCore = new CloudSolrServer(this.getIndexEndpoint());
            solrCore.setDefaultCollection(this.getPublicIndexCollection() + SOLR_COLLECTION_POSTFIX);
            response = solrCore.query((SolrParams)q);
            SolrDocumentList results = response.getResults();
            if (results.isEmpty()) {
                log.debug((Object)("Query " + q + " returned 0 documents"));
                ArrayList arrayList = Lists.newArrayList();
                return arrayList;
            }
            SolrDocument solrDoc = (SolrDocument)results.get(0);
            List<String> list = this.extractMergedIdentifiers(solrDoc);
            return list;
        }
        catch (Exception e) {
            log.error((Object)("Can't get original ids for " + id + "\n "), (Throwable)e);
            throw new RuntimeException("Can't get original ids for " + id + "\n " + e);
        }
        finally {
            solrCore.shutdown();
        }
    }

    protected List<String> extractMergedIdentifiers(SolrDocument doc) throws DocumentException {
        String xmlRecord = (String)doc.getFirstValue(RESULT_FIELD);
        Document xmlDoc = this.saxReader.read((Reader)new StringReader(xmlRecord));
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)xmlDoc.selectNodes(XPATH_TO_MERGED), (Function)new Function<Attribute, String>(){

            public String apply(Attribute a) {
                return a.getStringValue();
            }
        }));
    }

    protected String getIndexEndpoint() throws ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("for $x in collection('/db/DRIVER/ServiceResources/IndexServiceResourceType') return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    protected String getPublicIndexCollection() throws ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("for $x in collection('/db/DRIVER/ServiceResources/SearchServiceResourceType') return $x[.//PROPERTY[@key='infrastructure']/@value='public']//PROPERTY[@key='mdformat']/@value/string()");
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

