/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.blacklist;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.hadoop.rmi.HadoopServiceException;
import eu.dnetlib.data.hadoop.rmi.hbase.Column;
import eu.dnetlib.data.hadoop.rmi.hbase.HBaseRowDescriptor;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.blacklist.ResolvedBlacklistEntry;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.openaire.blacklist.BlacklistManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplyBlacklistJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ApplyBlacklistJobNode.class);
    @Autowired
    private BlacklistManager blacklistManager;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    private String clusterName;
    private String tableName;

    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference epr = this.blacklistManager.getAcceptedBlacklistEntries();
        HadoopService hadoopService = (HadoopService)this.serviceLocator.getService(HadoopService.class);
        SAXReader r = new SAXReader();
        HashMap relCache = Maps.newHashMap();
        int count = 0;
        for (String s : this.resultSetClientFactory.getClient(epr)) {
            Document doc = r.read((Reader)new StringReader(s));
            if (log.isDebugEnabled()) {
                log.debug((Object)doc.asXML());
            }
            ResolvedBlacklistEntry rbeRoot = new ResolvedBlacklistEntry();
            String source = this.fullId(doc.valueOf("//FIELD[./@name='source_type']"), doc.valueOf("//FIELD[./@name='source']"));
            rbeRoot.setSource(this.getResolvedId(source, hadoopService.describeHBaseColumn(this.getClusterName(), this.getTableName(), source).getColumns()));
            String target = this.fullId(doc.valueOf("//FIELD[./@name='target_type']"), doc.valueOf("//FIELD[./@name='target']"));
            rbeRoot.setTarget(this.getResolvedId(target, hadoopService.describeHBaseColumn(this.getClusterName(), this.getTableName(), target).getColumns()));
            String relType = doc.valueOf("//FIELD[./@name='relationship']");
            rbeRoot.setRelType(relType);
            ResolvedBlacklistEntry rbeNative = new ResolvedBlacklistEntry(source, target, relType);
            this.applyBlackListEntry(hadoopService, relCache, rbeRoot);
            this.applyBlackListEntry(hadoopService, relCache, rbeNative);
            ++count;
        }
        log.info((Object)("blacklist size: " + count));
        token.getEnv().setAttribute("blacklistSize", (Object)count);
        return Arc.DEFAULT_ARC;
    }

    private void applyBlackListEntry(HadoopService hadoopService, Map<String, String> relCache, ResolvedBlacklistEntry rbe) throws ISLookUpException, HadoopServiceException {
        if (!relCache.containsKey(rbe.getRelType())) {
            relCache.put(rbe.getRelType(), this.fetchInverse(rbe.getRelType()));
        }
        hadoopService.deleteHBaseColumn(this.getClusterName(), this.getTableName(), this.getHBaseRowDescriptor(rbe.getSource(), rbe.getTarget(), rbe.getRelType()));
        hadoopService.deleteHBaseColumn(this.getClusterName(), this.getTableName(), this.getHBaseRowDescriptor(rbe.getTarget(), rbe.getSource(), relCache.get(rbe.getRelType())));
    }

    private HBaseRowDescriptor getHBaseRowDescriptor(String source, String target, String relType) {
        ArrayList cols = Lists.newArrayList((Object[])new Column[]{new Column(relType, (List)Lists.newArrayList((Object[])new String[]{target}))});
        return new HBaseRowDescriptor(source, (List)cols);
    }

    private String fetchInverse(String relType) throws ISLookUpException {
        String xquery = "let $x:= /RESOURCE_PROFILE[ .//RESOURCE_TYPE/@value = 'OntologyDSResourceType' and  .//TERM/@encoding='" + relType + "']" + "let $y:= $x//TERM[./@encoding='" + relType + "']//RELATION[./@type='inverseOf']/@code/string() " + "return $x//TERM[./@code = $y]/@encoding/string()";
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
    }

    private String fullId(String type, String id) {
        String fullId = AbstractDNetXsltFunctions.oafSimpleId((String)type, (String)id);
        return OafRowKeyDecoder.decode((String)fullId).getKey();
    }

    private String getResolvedId(String originalId, List<Column> columns) {
        if (StringUtils.isBlank((String)originalId)) {
            throw new IllegalArgumentException("cannot resolve an empty id");
        }
        for (Column c : columns) {
            if (!c.getFamily().contains("isMergedIn")) continue;
            for (String s : c.getQualifier()) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                return s;
            }
        }
        return originalId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

